/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.distance;

import haubold.phylogeny.distance.UPGMATree;
import haubold.phylogeny.util.DistanceMatrix;
import haubold.phylogeny.util.Node;
import haubold.phylogeny.util.PrimateDistanceData;
import haubold.phylogeny.util.TreePanel;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;

public class DistanceTreeGUI
extends PrintableJPanel {
    JToolBar toolBar;
    JButton runButton;
    JButton resetButton;
    JButton printButton;
    JTextPane distancePane;
    JSplitPane splitPane;
    JComboBox algorithmBox;
    JScrollPane distanceScroll;
    TreePanel treePanel;
    UPGMATree upgmaTree;
    PrimateDistanceData distanceData;
    String initialDataString;
    String distanceText;
    JCheckBox branchLengthsCheck;
    JCheckBox leafLabelCheck;
    DecimalFormat decimalFormat = new DecimalFormat("0.000");
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    RunActionListener runActionListener;
    Node[] tree;
    FileOutputStream fos;
    JFrame fileChooserFrame;
    boolean mismatch;

    public DistanceTreeGUI() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.runButton = new JButton(Icons.get1rightArrow());
        this.runButton.setToolTipText("Compute Tree");
        this.runActionListener = new RunActionListener();
        this.runButton.addActionListener(this.runActionListener);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        ResetActionListener resetActionListener = new ResetActionListener();
        this.resetButton.addActionListener(resetActionListener);
        String[] algorithms = new String[]{"UPGMA", "Neighbor Joining", "Fitch-Margoliash"};
        this.algorithmBox = new JComboBox<String>(algorithms);
        this.algorithmBox.setEnabled(false);
        this.branchLengthsCheck = new JCheckBox("Show Branch Lengths");
        this.branchLengthsCheck.setSelected(false);
        BranchCheckActionListener bca = new BranchCheckActionListener();
        this.branchLengthsCheck.addActionListener(bca);
        this.leafLabelCheck = new JCheckBox("Show Names of Taxa");
        this.leafLabelCheck.setSelected(true);
        this.leafLabelCheck.addActionListener(bca);
        this.toolBar.add(this.runButton);
        this.toolBar.add(this.resetButton);
        this.toolBar.add(this.branchLengthsCheck);
        this.toolBar.add(this.leafLabelCheck);
        this.add((Component)this.toolBar, "North");
        this.distancePane = new JTextPane();
        Font font = new Font("Courier", 0, 12);
        this.distancePane.setFont(font);
        this.distancePane.setToolTipText("Distance matrix in PHYLIP format");
        this.distancePane.setBackground(this.bgc.getColor1());
        this.distanceScroll = new JScrollPane(this.distancePane);
        this.treePanel = new TreePanel();
        this.splitPane = new JSplitPane(0, this.distanceScroll, this.treePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        this.add((Component)this.splitPane, "Center");
    }

    private DistanceMatrix extractDistanceMatrix(String text) {
        DistanceMatrix distanceMatrix = new DistanceMatrix();
        String[] lines = text.split("\n");
        int n = 0;
        try {
            n = Integer.parseInt(lines[0]);
        }
        catch (Exception e) {
            JOptionPane optionPane = new JOptionPane("Please enter or generate a distance matrix first.", 0);
            JDialog dialog = optionPane.createDialog(this, "Error Message");
            dialog.setVisible(true);
            distanceMatrix = null;
            return distanceMatrix;
        }
        double[][] dm = new double[n][n];
        String[] taxa = new String[n];
        try {
            int i = 1;
            while (i < lines.length) {
                String[] components = lines[i].split("\\s+");
                taxa[i - 1] = components[0];
                int j = 1;
                while (j < components.length) {
                    if (j > i) {
                        dm[i - 1][j - 1] = Double.parseDouble(components[j]);
                        dm[j - 1][i - 1] = dm[i - 1][j - 1];
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane optionPane = new JOptionPane("There is an error in your distance matrix.", 0);
            JDialog dialog = optionPane.createDialog(this, "Error Message");
            dialog.setVisible(true);
            distanceMatrix = null;
            return distanceMatrix;
        }
        distanceMatrix.setDistanceMatrix(dm);
        distanceMatrix.setTaxa(taxa);
        return distanceMatrix;
    }

    public void runAction() {
        String text = this.distancePane.getText();
        DistanceMatrix distanceMatrix = this.extractDistanceMatrix(text);
        String algorithm = this.algorithmBox.getSelectedItem().toString();
        boolean branchLengths = this.branchLengthsCheck.isSelected();
        boolean leafLabels = this.leafLabelCheck.isSelected();
        this.treePanel.setBranchLengths(branchLengths);
        this.treePanel.setLeafLabels(leafLabels);
        if (distanceMatrix != null && algorithm == "UPGMA") {
            if (this.upgmaTree == null) {
                this.upgmaTree = new UPGMATree(distanceMatrix.getDistanceMatrix(), distanceMatrix.getTaxa());
            } else {
                this.upgmaTree.setTaxa(distanceMatrix.getTaxa());
                this.upgmaTree.setDistanceMatrix(distanceMatrix.getDistanceMatrix());
            }
            this.tree = this.upgmaTree.getTree();
            this.treePanel.setTree(this.tree);
        }
    }

    public String getDistanceText() {
        return this.distancePane.getText();
    }

    public void setDistanceText(String distanceText) {
        this.distanceText = distanceText;
        if (distanceText.length() > 0) {
            this.distancePane.setText(distanceText);
            this.distancePane.setCaretPosition(0);
            DistanceMatrix dm = this.extractDistanceMatrix(distanceText);
            this.initialDataString = this.distancePane.getText();
            this.treePanel.setTree(null);
        }
    }

    public JTextPane getDistancePane() {
        return this.distancePane;
    }

    public TreePanel getTreePanel() {
        return this.treePanel;
    }

    public void setDistancePane(JTextPane distancePane) {
        this.distancePane = distancePane;
    }

    public RunActionListener getRunActionListener() {
        return this.runActionListener;
    }

    public JScrollPane getDistanceScroll() {
        return this.distanceScroll;
    }

    public void setTreePanel(TreePanel treePanel) {
        this.treePanel = treePanel;
    }

    public Node[] getTree() {
        return this.tree;
    }

    public boolean isMismatch() {
        return this.mismatch;
    }

    public void setMismatch(boolean mismatch) {
        this.mismatch = mismatch;
    }

    class RunActionListener
    implements ActionListener {
        RunActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DistanceTreeGUI.this.runAction();
        }
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DistanceTreeGUI.this.distancePane.setText(DistanceTreeGUI.this.initialDataString);
            DistanceTreeGUI.this.distancePane.setCaretPosition(0);
            DistanceTreeGUI.this.treePanel.setTree(null);
            DistanceTreeGUI.this.branchLengthsCheck.setSelected(false);
            DistanceTreeGUI.this.leafLabelCheck.setSelected(true);
        }
    }

    class BranchCheckActionListener
    implements ActionListener {
        boolean branchLengths;
        boolean leafLabels;

        BranchCheckActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            this.branchLengths = DistanceTreeGUI.this.branchLengthsCheck.isSelected();
            this.leafLabels = DistanceTreeGUI.this.leafLabelCheck.isSelected();
            DistanceTreeGUI.this.treePanel.setBranchLengths(this.branchLengths);
            DistanceTreeGUI.this.treePanel.setLeafLabels(this.leafLabels);
            DistanceTreeGUI.this.treePanel.repaint();
        }
    }
}

