/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.util;

import haubold.phylogeny.util.LeafNode;
import haubold.phylogeny.util.Node;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class TreePanel
extends JPanel {
    Node[] tree = null;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    double treeXDim;
    double treeYDim;
    double border = 0.1;
    int maximumLabelLength = 0;
    double defaultSize = 200.0;
    double prescale;
    DecimalFormat decimalFormat = new DecimalFormat("0.000");
    boolean branchLengths = false;
    boolean leafLabels = true;
    Color backgroundColor = this.bgc.getColor4();
    Color taxonColor = this.bgc.getColor3();
    Color distanceColor = this.bgc.getColor5();

    public TreePanel() {
    }

    public TreePanel(Node[] tree) {
        this.tree = tree;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.backgroundColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(Color.black);
        if (this.tree != null) {
            double xScale = ((double)this.getWidth() - (double)this.getWidth() * this.border) / (this.treeXDim + (double)this.maximumLabelLength * 6.0);
            double yScale = ((double)this.getHeight() - (double)this.getHeight() * this.border) / this.treeYDim;
            double scale = Math.min(xScale, yScale);
            double tx = ((double)this.getWidth() - (this.treeXDim + (double)this.maximumLabelLength * 6.0) * scale) / 2.0;
            double ty = ((double)this.getHeight() - this.treeYDim * scale) / 2.0;
            AffineTransform transform = g2.getTransform();
            g2.translate(tx, ty);
            g2.scale(scale, scale);
            this.drawTree(g2);
            g2.setTransform(transform);
        }
    }

    public void drawPDF(Graphics2D g2) {
        int width = 400;
        int height = 150;
        if (this.tree != null) {
            double xScale = ((double)width - (double)width * this.border) / (this.treeXDim + (double)this.maximumLabelLength * 6.0);
            double yScale = ((double)height - (double)height * this.border) / this.treeYDim;
            double scale = Math.min(xScale, yScale);
            double tx = ((double)width - (this.treeXDim + (double)this.maximumLabelLength * 6.0) * scale) / 2.0;
            double ty = ((double)height - this.treeYDim * scale) / 2.0;
            AffineTransform transform = g2.getTransform();
            g2.translate(tx, ty);
            g2.scale(scale, scale);
            this.drawTree(g2);
            g2.setTransform(transform);
        }
    }

    private void drawTree(Graphics2D g2) {
        int i = 0;
        while (i < this.tree.length) {
            if (this.tree[i].getParent() != null) {
                g2.drawLine((int)this.treeXDim - (int)this.tree[i].getYPosition(), (int)this.tree[i].getXPosition(), (int)this.treeXDim - (int)this.tree[i].getParent().getYPosition(), (int)this.tree[i].getParent().getXPosition());
                if (this.branchLengths) {
                    double bl = this.tree[i].getParent().getNodeHeight() - this.tree[i].getNodeHeight();
                    double sx = this.treeXDim - (this.tree[i].getYPosition() + (this.tree[i].getParent().getYPosition() - this.tree[i].getYPosition()) / 2.0);
                    double sy = this.tree[i].getXPosition() + (this.tree[i].getParent().getXPosition() - this.tree[i].getXPosition()) / 2.0;
                    g2.setColor(this.distanceColor);
                    g2.drawString(this.decimalFormat.format(bl), (int)sx, (int)sy);
                    g2.setColor(Color.black);
                }
            }
            if (this.tree[i].isLeaf() && this.leafLabels) {
                g2.setColor(this.taxonColor);
                g2.drawString(((LeafNode)this.tree[i]).getLabel(), (int)this.treeXDim - (int)this.tree[i].getYPosition() + 2, (int)this.tree[i].getXPosition() + 5);
                g2.setColor(Color.BLACK);
            }
            ++i;
        }
        double scaleLength = this.treeXDim / 10.0;
        g2.drawLine(0, 5, (int)scaleLength, 5);
        g2.drawString(this.decimalFormat.format(this.tree[this.tree.length - 1].getNodeHeight() / 10.0), 0, 4);
    }

    public Node[] getTree() {
        return this.tree;
    }

    public void setTree(Node[] tree) {
        this.tree = tree;
        if (tree != null) {
            this.treeXDim = this.computeXDim(tree);
            this.treeYDim = this.computeYDim(tree);
            this.prescaleTree(tree);
            this.maximumLabelLength = this.computeMaximumLabelLength(tree);
        }
        this.repaint();
    }

    private double computeXDim(Node[] tree) {
        double xDim = Double.MIN_VALUE;
        int i = 0;
        while (i < tree.length) {
            if (xDim < tree[i].getYPosition()) {
                xDim = tree[i].getYPosition();
            }
            ++i;
        }
        return xDim;
    }

    private double computeYDim(Node[] tree) {
        double yDim = Double.MIN_VALUE;
        int i = 0;
        while (i < tree.length) {
            if (yDim < tree[i].getXPosition()) {
                yDim = tree[i].getXPosition();
            }
            ++i;
        }
        return yDim;
    }

    private void prescaleTree(Node[] tree) {
        this.prescale = this.defaultSize / Math.min(this.treeXDim, this.treeYDim);
        int i = 0;
        while (i < tree.length) {
            tree[i].setXPosition(tree[i].getXPosition() * this.prescale);
            tree[i].setYPosition(tree[i].getYPosition() * this.prescale);
            ++i;
        }
        this.treeXDim *= this.prescale;
        this.treeYDim *= this.prescale;
    }

    private int computeMaximumLabelLength(Node[] tree) {
        int maximumLabelLength = Integer.MIN_VALUE;
        int i = 0;
        while (i < tree.length) {
            if (tree[i].isLeaf() && maximumLabelLength < ((LeafNode)tree[i]).getLabel().length()) {
                maximumLabelLength = ((LeafNode)tree[i]).getLabel().length();
            }
            ++i;
        }
        return maximumLabelLength;
    }

    public boolean isBranchLengths() {
        return this.branchLengths;
    }

    public void setBranchLengths(boolean branchLengths) {
        this.branchLengths = branchLengths;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        System.out.println("Set background color");
        this.repaint();
    }

    public Color getTaxonColor() {
        return this.taxonColor;
    }

    public void setTaxonColor(Color taxonColor) {
        this.taxonColor = taxonColor;
    }

    public Color getDistanceColor() {
        return this.distanceColor;
    }

    public void setDistanceColor(Color distanceColor) {
        this.distanceColor = distanceColor;
    }

    public boolean isLeafLabels() {
        return this.leafLabels;
    }

    public void setLeafLabels(boolean leafLabels) {
        this.leafLabels = leafLabels;
    }
}

