/*
 * Decompiled with CFR 0.152.
 */
package haubold.probabilitydistribution;

import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

public class ExtremeValueDistribution
extends AbstractXYDataset
implements XYDataset {
    private static final long serialVersionUID = 1L;
    double lambda = 1.0;
    double mu = 0.0;
    private double translate;

    public ExtremeValueDistribution(double lambda, double mu) {
        this.lambda = lambda;
        this.mu = mu;
        this.translate = 0.0;
    }

    public double getTranslate() {
        return this.translate;
    }

    public void setTranslate(double translate) {
        this.translate = translate;
        this.notifyListeners(new DatasetChangeEvent((Object)this, (Dataset)this));
    }

    public Number getX(int series, int item) {
        return new Double(-3.0 + this.translate + (double)item / 3.0);
    }

    public Number getY(int series, int item) {
        double x = -3.0 + this.translate + (double)item / 3.0;
        double y = series == 0 ? this.lambda * Math.exp((this.mu - x) * this.lambda - Math.exp((this.mu - x) * this.lambda)) : Math.exp(-Math.exp(this.mu - x) * this.lambda);
        return new Double(y);
    }

    public int getSeriesCount() {
        return 2;
    }

    public Comparable getSeriesKey(int series) {
        if (series == 0) {
            return "Probability Density Function";
        }
        if (series == 1) {
            return "Cumulative Density Function";
        }
        return "Error";
    }

    public int getItemCount(int series) {
        return 35;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.notifyListeners(new DatasetChangeEvent((Object)this, (Dataset)this));
        this.lambda = lambda;
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double mu) {
        this.notifyListeners(new DatasetChangeEvent((Object)this, (Dataset)this));
        this.mu = mu;
    }
}

