/*
 * Decompiled with CFR 0.152.
 */
package haubold.probabilitydistribution;

import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MutationPanel
extends PrintableJPanel {
    BirkhaeuserGUIComponents bgc;
    JToolBar toolBar;
    JSlider popSizeSlider;
    JSlider pSlider;
    JButton runButton;
    JButton stopButton;
    JButton resetButton;
    boolean stop;
    Random ran;
    int numPop;
    int initialPopSize;
    int initialP;
    int liveCount;
    double allele;
    XYSeriesCollection dataset;
    JFreeChart chart;
    ChartPanel chartPanel;

    public MutationPanel() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.initialPopSize = 100;
        this.initialP = 5;
        this.bgc = new BirkhaeuserGUIComponents();
        this.popSizeSlider = this.bgc.getSlider(0, 200, this.initialPopSize, "Population Size");
        this.pSlider = this.bgc.getSlider(0, 10, this.initialP, "Mutation Rate x 1000");
        this.runButton = new JButton(Icons.get1rightArrow());
        this.stopButton = new JButton(Icons.getStop());
        this.resetButton = new JButton(Icons.getUndo());
        this.runButton.addActionListener(new RunActionListener());
        this.stopButton.addActionListener(new StopActionListener());
        this.resetButton.addActionListener(new ResetActionListener());
        this.runButton.setToolTipText("Run");
        this.stopButton.setToolTipText("Stop");
        this.resetButton.setToolTipText("Reset");
        this.toolBar.add(this.popSizeSlider);
        this.toolBar.add(this.pSlider);
        this.toolBar.add(this.runButton);
        this.toolBar.add(this.stopButton);
        this.toolBar.add(this.resetButton);
        this.add((Component)this.toolBar, "North");
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)"", (String)"Generation", (String)"Genetic diversity, h", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(false);
        rangeAxis.setRange(0.0, 1.0);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setRange(1.0, 1000.0);
        this.chartPanel = new ChartPanel(this.chart);
        this.add((Component)this.chartPanel, "Center");
        this.stop = true;
        this.liveCount = 0;
        this.ran = new Random();
    }

    class StopActionListener
    implements ActionListener {
        StopActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MutationPanel.this.stop = true;
            MutationPanel.this.stopButton.setEnabled(false);
            MutationPanel.this.resetButton.setEnabled(true);
        }
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MutationPanel.this.dataset.removeAllSeries();
            MutationPanel.this.numPop = 0;
            MutationPanel.this.resetButton.setEnabled(false);
            MutationPanel.this.popSizeSlider.setValue(MutationPanel.this.initialPopSize);
            MutationPanel.this.pSlider.setValue(MutationPanel.this.initialP);
        }
    }

    class RunActionListener
    implements ActionListener {
        XYSeries xysObs;
        XYSeries xysExp;
        String identifierObs;
        String identifierExp;
        DataGenerator generator;

        RunActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MutationPanel.this.stop) {
                MutationPanel.this.stop = false;
                MutationPanel.this.resetButton.setEnabled(false);
                MutationPanel.this.stopButton.setEnabled(true);
            }
            if (MutationPanel.this.popSizeSlider.getValue() > 1) {
                this.identifierObs = new String();
                this.identifierObs = "Pop_" + ++MutationPanel.this.numPop + ", N=" + MutationPanel.this.popSizeSlider.getValue();
                this.identifierExp = "Pop_" + MutationPanel.this.numPop + ", exp";
                this.xysObs = new XYSeries((Comparable)((Object)this.identifierObs));
                this.xysExp = new XYSeries((Comparable)((Object)this.identifierExp));
                MutationPanel.this.dataset.addSeries(this.xysObs);
                MutationPanel.this.dataset.addSeries(this.xysExp);
                this.generator = new DataGenerator(10, this.xysObs, this.xysExp);
                this.generator.start();
                ++MutationPanel.this.liveCount;
            }
        }
    }

    class DataGenerator
    extends Timer
    implements ActionListener {
        XYSeries xysObs;
        XYSeries xysExp;
        double[] pop1;
        double[] pop2;
        short indexFrom;
        short indexTo;
        int popSize;
        int popSizeMinusOne;
        double generationCounter;
        boolean first = true;
        double mu;
        double hExp;

        DataGenerator(int interval, XYSeries xysObs, XYSeries xysExp) {
            super(interval, null);
            this.addActionListener(this);
            this.xysObs = xysObs;
            this.xysExp = xysExp;
            this.popSize = MutationPanel.this.popSizeSlider.getValue();
            this.popSizeMinusOne = this.popSize - 1;
            this.mu = (double)MutationPanel.this.pSlider.getValue() / 1000.0;
            this.hExp = (double)(2 * this.popSize) * this.mu / (2.0 * (double)this.popSize * this.mu + 1.0);
            this.pop1 = new double[this.popSize];
            this.pop2 = new double[this.popSize];
            int i = 0;
            while (i < this.popSize) {
                this.pop1[i] = MutationPanel.this.allele;
                ++i;
            }
            this.generationCounter = 0.0;
        }

        public void actionPerformed(ActionEvent event) {
            if (!MutationPanel.this.stop) {
                double h = 0.0;
                int i = 0;
                while (i < this.popSizeMinusOne) {
                    int j = i + 1;
                    while (j < this.popSize) {
                        if (this.pop1[i] != this.pop1[j]) {
                            h += 1.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.xysObs.add(this.generationCounter += 1.0, h /= (double)this.popSize * (double)(this.popSize - 1) / 2.0);
                this.xysExp.add(this.generationCounter, this.hExp);
                i = 0;
                while (i < this.popSize) {
                    if (MutationPanel.this.ran.nextDouble() < this.mu) {
                        this.pop1[i] = MutationPanel.this.allele += 1.0;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.popSize) {
                    int r = MutationPanel.this.ran.nextInt(this.popSize);
                    this.pop2[i] = this.pop1[r];
                    ++i;
                }
                i = 0;
                while (i < this.popSize) {
                    this.pop1[i] = this.pop2[i];
                    ++i;
                }
            }
        }
    }
}

