/*
 * Decompiled with CFR 0.152.
 */
package haubold.probabilitydistribution;

import haubold.probabilitydistribution.NormalPDF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class NormalDistributionDemo
extends ApplicationFrame {
    JPanel distributionPanel;
    JSlider sigmaSlider;
    JSlider muSlider;
    Function2D normal = new NormalPDF(0.0, 1.0);
    XYDataset dataset = DatasetUtilities.sampleFunction2D((Function2D)this.normal, (double)-15.0, (double)15.0, (int)200, (Comparable)((Object)"Normal"));
    JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"X", (String)"Y", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    AxisSpace as;

    public NormalDistributionDemo(String title) {
        super(title);
        this.chart.getXYPlot().getRangeAxis().setAutoRange(false);
        this.chart.getXYPlot().getRangeAxis().setRange(0.0, 1.0);
        this.distributionPanel = new JPanel();
        JToolBar toolBar = new JToolBar();
        this.sigmaSlider = new JSlider(0, 500, 100);
        this.sigmaSlider.setPaintTicks(true);
        this.sigmaSlider.setMajorTickSpacing(100);
        this.sigmaSlider.setMinorTickSpacing(20);
        this.sigmaSlider.setBorder(new TitledBorder("sigma"));
        this.sigmaSlider.setPaintLabels(true);
        this.sigmaSlider.getLabelTable().put(new Integer(100), new JLabel("1"));
        this.sigmaSlider.getLabelTable().put(new Integer(200), new JLabel("2"));
        this.sigmaSlider.getLabelTable().put(new Integer(300), new JLabel("3"));
        this.sigmaSlider.getLabelTable().put(new Integer(400), new JLabel("4"));
        this.sigmaSlider.getLabelTable().put(new Integer(500), new JLabel("5"));
        this.sigmaSlider.setLabelTable(this.sigmaSlider.getLabelTable());
        this.muSlider = new JSlider(-1500, 1500, 0);
        this.muSlider.setPaintTicks(true);
        this.muSlider.setPaintLabels(true);
        this.muSlider.setMajorTickSpacing(500);
        this.muSlider.setMinorTickSpacing(100);
        this.muSlider.setBorder(new TitledBorder("mu"));
        int i = -15;
        while (i <= 15) {
            this.muSlider.getLabelTable().put(new Integer(i * 100), new JLabel(String.valueOf(i)));
            i += 5;
        }
        this.muSlider.setLabelTable(this.muSlider.getLabelTable());
        SliderListener sl = new SliderListener();
        this.sigmaSlider.addChangeListener(sl);
        this.muSlider.addChangeListener(sl);
        toolBar.add(this.sigmaSlider);
        toolBar.add(this.muSlider);
        this.distributionPanel.setLayout(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(this.chart);
        this.distributionPanel.add((Component)chartPanel, "Center");
        this.distributionPanel.add((Component)toolBar, "North");
        this.setContentPane(this.distributionPanel);
    }

    public static void main(String[] args) {
        NormalDistributionDemo demo = new NormalDistributionDemo("Normal Distribution Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent e) {
            NormalDistributionDemo.this.normal = new NormalPDF((double)NormalDistributionDemo.this.muSlider.getValue() / 100.0, (double)NormalDistributionDemo.this.sigmaSlider.getValue() / 100.0);
            NormalDistributionDemo.this.dataset = DatasetUtilities.sampleFunction2D((Function2D)NormalDistributionDemo.this.normal, (double)-15.0, (double)15.0, (int)200, (Comparable)((Object)"Normal"));
            NormalDistributionDemo.this.chart.getXYPlot().setDataset(NormalDistributionDemo.this.dataset);
            NormalDistributionDemo.this.chart.fireChartChanged();
        }
    }
}

