/*
 * Decompiled with CFR 0.152.
 */
package haubold.resources.demo;

import haubold.resources.util.HelpActionListener;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class DemoHelpMenu
extends JMenu {
    private JTextPane textPane;
    private JScrollPane scrollPane;
    private JMenuItem helpMenuItem;
    private HelpActionListener hal;
    JEditorPane html;
    JDesktopPane desktop;
    Dimension dimension;
    String titleString;
    JToolBar toolBar;
    JButton toolButton;

    public DemoHelpMenu(String helpPath, JDesktopPane desktop, String titleString) {
        this.setText("Help");
        this.setMnemonic(72);
        this.helpMenuItem = new JMenuItem("Help");
        this.helpMenuItem.setMnemonic('h');
        this.dimension = new Dimension(300, 300);
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        try {
            URL url = ClassLoader.getSystemResource(helpPath);
            if (url != null) {
                this.html = new JEditorPane(url);
                this.html.setEditable(false);
                this.html.addHyperlinkListener(this.createHyperLinkListener());
                JScrollPane scroller = new JScrollPane();
                JViewport vp = scroller.getViewport();
                vp.add(this.html);
                this.hal = new HelpActionListener(desktop, scroller, this.dimension, titleString);
                this.helpMenuItem.addActionListener(this.hal);
                this.add(this.helpMenuItem);
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
    }

    public void setHelpText(String helpText) {
        this.textPane.setText(helpText);
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)DemoHelpMenu.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            DemoHelpMenu.this.html.setPage(e.getURL());
                        }
                        catch (IOException ioe) {
                            System.out.println("IOE: " + ioe);
                        }
                    }
                }
            }
        };
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(JToolBar bar) {
        this.toolBar = bar;
        this.hal.setToolBar(this.toolBar);
    }
}

