/*
 * Decompiled with CFR 0.152.
 */
package haubold.resources.util;

import java.awt.Graphics2D;
import java.awt.geom.QuadCurve2D;

public class Arrow {
    float arrowSize = 10.0f;
    float arrowAngle = (float)Math.toRadians(15.0);

    public void drawArrow(Graphics2D g2, float x1, float y1, float x2, float y2) {
        float angle = (float)Math.atan2(y2 - y1, x2 - x1) + (float)Math.PI;
        float x3 = (int)((double)x2 + Math.cos(angle - this.arrowAngle) * (double)this.arrowSize);
        float y3 = (int)((double)y2 + Math.sin(angle - this.arrowAngle) * (double)this.arrowSize);
        float x4 = (int)((double)x2 + Math.cos(angle + this.arrowAngle) * (double)this.arrowSize);
        float y4 = (int)((double)y2 + Math.sin(angle + this.arrowAngle) * (double)this.arrowSize);
        g2.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
        g2.drawLine((int)x2, (int)y2, (int)x4, (int)y4);
        g2.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
        g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void drawQuadArrow(Graphics2D g2, float x1, float y1, float ctrlX, float ctrlY, float x2, float y2) {
        QuadCurve2D.Float quad = new QuadCurve2D.Float();
        quad.setCurve(x1, y1, ctrlX, ctrlY, x2, y2);
        g2.draw(quad);
        float angle = (float)Math.atan2(y2 - ctrlY, x2 - ctrlX) + (float)Math.PI;
        float x3 = (int)((double)x2 + Math.cos(angle - this.arrowAngle) * (double)this.arrowSize);
        float y3 = (int)((double)y2 + Math.sin(angle - this.arrowAngle) * (double)this.arrowSize);
        float x4 = (int)((double)x2 + Math.cos(angle + this.arrowAngle) * (double)this.arrowSize);
        float y4 = (int)((double)y2 + Math.sin(angle + this.arrowAngle) * (double)this.arrowSize);
        g2.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
        g2.drawLine((int)x2, (int)y2, (int)x4, (int)y4);
        g2.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
    }

    public void drawArrowHead(Graphics2D g2, float x, float y, float ctrlX, float ctrlY) {
        float angle = (float)Math.atan2(y - ctrlY, x - ctrlX) + (float)Math.PI;
        float x3 = (int)((double)x + Math.cos(angle - this.arrowAngle) * (double)this.arrowSize);
        float y3 = (int)((double)y + Math.sin(angle - this.arrowAngle) * (double)this.arrowSize);
        float x4 = (int)((double)x + Math.cos(angle + this.arrowAngle) * (double)this.arrowSize);
        float y4 = (int)((double)y + Math.sin(angle + this.arrowAngle) * (double)this.arrowSize);
        g2.drawLine((int)x, (int)y, (int)x3, (int)y3);
        g2.drawLine((int)x, (int)y, (int)x4, (int)y4);
        g2.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(float arrowSize) {
        this.arrowSize = arrowSize;
    }

    public float getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(float arrowAngle) {
        this.arrowAngle = arrowAngle;
    }
}

