/*
 * Decompiled with CFR 0.152.
 */
package haubold.sm;

import haubold.sm.MatrixDisplayPanel;
import haubold.sm.SubstitutionMatrix;
import haubold.sm.SubstitutionMatrixReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class BlosumPanel
extends JPanel {
    JToolBar toolBar;
    JComboBox comboBox;
    String[] matrices = new String[]{"blosum45", "blosum62", "blosum80"};
    MatrixDisplayPanel displayPanel;
    SubstitutionMatrixReader substitutionMatrixReader;
    StringBuffer sb;
    String[] aminoAcids = new String[20];
    int[][] values = new int[20][20];

    public BlosumPanel() {
        this.substitutionMatrixReader = new SubstitutionMatrixReader();
        this.constructGui();
        this.sb = new StringBuffer();
    }

    private void constructGui() {
        SubstitutionMatrix sm = null;
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.comboBox = new JComboBox<String>(this.matrices);
        this.comboBox.setMaximumSize(new Dimension(100, 20));
        this.comboBox.addActionListener(new ComboBoxListener());
        this.toolBar.add(this.comboBox);
        this.add((Component)this.toolBar, "North");
        try {
            sm = this.substitutionMatrixReader.getSubstitutionMatrix(this.matrices[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.displayPanel = new MatrixDisplayPanel(sm.getValues(), sm.getAminoAcids(), -1);
        this.add((Component)this.displayPanel, "Center");
    }

    class ComboBoxListener
    implements ActionListener {
        ComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SubstitutionMatrix sm = null;
            String matrix = (String)BlosumPanel.this.comboBox.getSelectedItem();
            try {
                sm = BlosumPanel.this.substitutionMatrixReader.getSubstitutionMatrix(matrix);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            int i = 0;
            while (i < 20) {
                BlosumPanel.this.aminoAcids[i] = sm.getAminoAcids()[i];
                int j = 0;
                while (j < 20) {
                    BlosumPanel.this.values[i][j] = sm.getValues()[i][j];
                    ++j;
                }
                ++i;
            }
            BlosumPanel.this.displayPanel.setAminoAcids(BlosumPanel.this.aminoAcids);
            BlosumPanel.this.displayPanel.setValues(BlosumPanel.this.values);
            BlosumPanel.this.displayPanel.setPercentDifference(-1);
            BlosumPanel.this.displayPanel.repaint();
        }
    }
}

