/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.classical;

import haubold.resources.demo.DemoFrame;
import haubold.resources.util.DataContainer;
import haubold.resources.util.Icons;
import haubold.resources.util.OpenSequenceMenuItem;
import haubold.stringmatching.classical.NaiveAlgorithm;
import haubold.stringmatching.classical.ZAlgorithm;
import haubold.stringmatching.suffixtree.algorithms.UkkonenSuffixTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class StringMatchingDemo
extends DemoFrame {
    JLabel timeLabel;
    JLabel preprocessLabel;
    JLabel patternLabel;
    JTextPane textPane;
    JTextField patternField;
    JComboBox textBox;
    JComboBox algorithmBox;
    StyledDocument document;
    DataContainer container;
    SimpleAttributeSet defaultAttributes;
    SimpleAttributeSet selectedAttributes;
    NaiveAlgorithm naiveAlgorithm;
    ZAlgorithm zAlgorithm;
    UkkonenSuffixTree suffixTree;
    String initPattern = "ACGT";
    String NAIVE = "Naive";
    String Z = "Z";
    String SUFFIX = "Suffix Tree";
    String HAEM = "Haemophilus Genome";
    String PHI = "Phi-X174 Genome";
    String ADH = "Drosophila Adh";
    String DNA = "Double Helix Paper";
    String BLANK = "Blank Page";
    String firstTextBoxItem;
    String firstAlgorithmBoxItem;

    public StringMatchingDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.container = new DataContainer();
        JPanel stringPanel = new JPanel(new BorderLayout());
        JPanel patternPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        JButton matchButton = new JButton(Icons.get1rightArrow());
        matchButton.setToolTipText("Match");
        MatchButtonListener buttonListener = new MatchButtonListener();
        JButton resetButton = new JButton(Icons.getUndo());
        resetButton.setToolTipText("Reset");
        ResetActionListener resetActionListener = new ResetActionListener();
        resetButton.addActionListener(resetActionListener);
        matchButton.addActionListener(buttonListener);
        String[] algorithmElements = new String[]{this.NAIVE, this.Z, this.SUFFIX};
        String[] textElements = new String[]{this.PHI, this.ADH, this.DNA, this.BLANK};
        this.firstTextBoxItem = this.PHI;
        this.firstAlgorithmBoxItem = this.NAIVE;
        this.algorithmBox = new JComboBox<String>(algorithmElements);
        this.algorithmBox.setToolTipText("Algorithm");
        this.textBox = new JComboBox<String>(textElements);
        this.textBox.setToolTipText("Text for searching");
        TextBoxListener textBoxListener = new TextBoxListener();
        this.textBox.addActionListener(textBoxListener);
        this.timeLabel = new JLabel(" Search:        ");
        this.timeLabel.setToolTipText("Time (in milliseconds) for searching.");
        this.preprocessLabel = new JLabel(" Preprocess:     ");
        this.preprocessLabel.setToolTipText("Time (in milliseconds) for preprocessing");
        this.timeLabel.setEnabled(false);
        this.preprocessLabel.setEnabled(false);
        toolBar.add(matchButton);
        toolBar.add(resetButton);
        toolBar.add(this.algorithmBox);
        toolBar.add(this.textBox);
        toolBar.add(this.timeLabel);
        toolBar.add(this.preprocessLabel);
        this.patternLabel = new JLabel(" Pattern ");
        this.patternField = new JTextField(this.initPattern);
        this.patternField.setToolTipText("Enter pattern and press RETURN");
        PatternFieldListener patternFieldListener = new PatternFieldListener();
        MatchButtonListener matchButtonListener = new MatchButtonListener();
        this.patternField.addActionListener(patternFieldListener);
        matchButton.addActionListener(matchButtonListener);
        patternPanel.add((Component)this.patternLabel, "West");
        patternPanel.add((Component)this.patternField, "Center");
        int width = 60;
        int height = this.patternLabel.getHeight();
        Dimension labelDimension = new Dimension(width, 10);
        stringPanel.add((Component)toolBar, "North");
        stringPanel.add((Component)patternPanel, "South");
        StyleContext context = new StyleContext();
        this.document = new DefaultStyledDocument(context);
        this.defaultAttributes = new SimpleAttributeSet();
        this.selectedAttributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.defaultAttributes, "monospaced");
        StyleConstants.setFontSize(this.defaultAttributes, 12);
        StyleConstants.setFontFamily(this.selectedAttributes, "monospaced");
        StyleConstants.setFontSize(this.selectedAttributes, 12);
        StyleConstants.setBackground(this.selectedAttributes, new Color(255, 204, 51));
        this.textPane = new JTextPane(this.document);
        this.textPane.setEditable(true);
        this.textPane.setDoubleBuffered(true);
        this.textPane.setFont(new Font("monospaced", 0, 12));
        OpenSequenceMenuItem osmi = new OpenSequenceMenuItem("Open Sequence", this.textPane);
        osmi.setMnemonic(79);
        osmi.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.getFileMenu().add((Component)osmi, 0);
        this.suffixTree = new UkkonenSuffixTree();
        this.naiveAlgorithm = new NaiveAlgorithm();
        this.zAlgorithm = new ZAlgorithm();
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)stringPanel, "North");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.timeLabel.setPreferredSize(new Dimension(100, 20));
        this.preprocessLabel.setPreferredSize(new Dimension(140, 20));
        this.setText();
    }

    private void setText() {
        String item = (String)this.textBox.getSelectedItem();
        String text = item.equals(this.HAEM) ? "Not available." : (item.equals(this.ADH) ? this.container.getAdh2() : (item.equals(this.PHI) ? this.container.getPhi() : (item.equals(this.DNA) ? this.container.getWatsonCrick() : "")));
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, text, this.defaultAttributes);
            this.textPane.setCaretPosition(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void search() {
        ArrayList list = null;
        String algorithm = (String)this.algorithmBox.getSelectedItem();
        String pattern = this.patternField.getText();
        String text = "";
        long t1 = 0L;
        long t2 = 0L;
        try {
            this.document.setCharacterAttributes(0, this.document.getLength(), this.defaultAttributes, true);
            text = this.document.getText(0, this.document.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (algorithm.equals(this.NAIVE) && pattern.length() > 0 && text.length() > 0) {
            t1 = System.currentTimeMillis();
            list = this.naiveAlgorithm.match(pattern, text);
            t2 = System.currentTimeMillis();
            this.preprocessLabel.setEnabled(false);
            this.preprocessLabel.setText(" Preprocess: ");
        } else if (algorithm.equals(this.Z) && pattern.length() > 0 && text.length() > 0) {
            t1 = System.currentTimeMillis();
            this.zAlgorithm.preprocess(pattern, text);
            t2 = System.currentTimeMillis();
            this.preprocessLabel.setEnabled(true);
            this.preprocessLabel.setText(" Preprocess: " + (t2 - t1) + " ms.");
            t1 = System.currentTimeMillis();
            list = this.zAlgorithm.match(pattern, text);
            t2 = System.currentTimeMillis();
        } else if (algorithm.equals(this.SUFFIX) && pattern.length() > 0 && text.length() > 0) {
            t1 = System.currentTimeMillis();
            this.suffixTree.constructSuffixTree((String.valueOf(text) + "\u0000").toCharArray());
            t2 = System.currentTimeMillis();
            this.preprocessLabel.setEnabled(true);
            this.preprocessLabel.setText(" Preprocess: " + (t2 - t1) + " ms.");
            t1 = System.currentTimeMillis();
            list = this.suffixTree.match(pattern.toCharArray());
            t2 = System.currentTimeMillis();
        }
        this.timeLabel.setEnabled(true);
        this.timeLabel.setText(" Search: " + (t2 - t1) + " ms.");
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                this.document.setCharacterAttributes((Integer)list.get(i), pattern.length(), this.selectedAttributes, true);
                ++i;
            }
        } else {
            System.out.println("List is null");
        }
    }

    class StringListener
    implements ActionListener {
        StringListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Action performed");
        }
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StringMatchingDemo.this.timeLabel.setText(" Search:        ");
            StringMatchingDemo.this.timeLabel.setEnabled(false);
            StringMatchingDemo.this.preprocessLabel.setText(" Preprocess:     ");
            StringMatchingDemo.this.preprocessLabel.setEnabled(false);
            StringMatchingDemo.this.textBox.setSelectedIndex(0);
            StringMatchingDemo.this.algorithmBox.setSelectedIndex(0);
            StringMatchingDemo.this.setText();
            StringMatchingDemo.this.patternField.setText(StringMatchingDemo.this.initPattern);
        }
    }

    class TextBoxListener
    implements ActionListener {
        TextBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StringMatchingDemo.this.setText();
        }
    }

    class MatchButtonListener
    implements ActionListener {
        MatchButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StringMatchingDemo.this.search();
        }
    }

    class PatternFieldListener
    implements ActionListener {
        PatternFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StringMatchingDemo.this.search();
        }
    }
}

