/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import haubold.stringmatching.suffixtree.algorithms.SuffixNode;
import haubold.stringmatching.suffixtree.algorithms.SuffixTree;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DrawSTLatex {
    int xPos = 0;
    PrintWriter pw;
    OutputStream os;
    char[] text;
    SuffixNode root;
    int levels;
    String outFile;
    float levelScale = 2.5f;
    public static int DOT_NODE = 0;
    public static int CIRCLE_NODE = 1;
    public static int COMPLETE_GRAPHIC = 0;
    public static int INSERTION_GRAPHIC = 1;
    private int nodeType;
    private int graphicType;

    public void draw(SuffixTree st) {
        this.root = st.getRoot();
        this.text = st.getText();
        this.draw(st, "suffixTree.tex");
    }

    public void draw(SuffixTree st, String outFile) {
        this.root = st.getRoot();
        this.text = st.getText();
        try {
            this.os = new FileOutputStream(outFile);
            this.pw = new PrintWriter(this.os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.graphicType == COMPLETE_GRAPHIC) {
            this.pw.print(this.getHeader());
        }
        this.xPos = 0;
        this.levels = 0;
        this.root.setYPos(0.0f);
        this.initializePositions(this.root);
        this.root.setYPos(this.root.getYPos() * (this.levelScale + 1.0f));
        this.traverseTree(this.root, false);
        this.pw.print("\\begin{pspicture}(" + this.xPos + "," + this.root.getYPos() + ")\n\\psset{linecolor=lightgray}\n");
        this.traverseTree(this.root, true);
        this.pw.print("\\end{pspicture}");
        if (this.graphicType == COMPLETE_GRAPHIC) {
            this.pw.print(this.getFooter());
        }
        try {
            this.pw.close();
            this.os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializePositions(SuffixNode node) {
        node.setXPos(0.0f);
        node.setYPos(0.0f);
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.localizeLeaves(children[i]);
                ++i;
            }
            node.setYPos(children[0].getYPos() + 1.0f);
        } else {
            node.setXPos(this.xPos++);
        }
    }

    private void traverseTree(SuffixNode node, boolean output) {
        if (node.getParent() != null) {
            node.setYPos(node.getParent().getYPos() - this.levelScale);
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.traverseTree(children[i], output);
                ++i;
            }
            node.setXPos(children[0].getXPos() + (children[children.length - 1].getXPos() - children[0].getXPos()) / 2.0f);
        }
        if (output) {
            this.drawNode(node);
        }
    }

    private void drawNode(SuffixNode node) {
        if (this.nodeType == CIRCLE_NODE) {
            this.pw.print("\\rput(" + node.getXPos() + "," + node.getYPos() + "){\\circlenode{" + node.getId() + "}{" + node.getId() + "}}\n");
        } else {
            this.pw.print("\\dotnode(" + node.getXPos() + "," + node.getYPos() + "){" + node.getId() + "}\n");
        }
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.pw.print("\\pstextpath[c]{\\psline(" + node.getXPos() + "," + node.getYPos() + ")(" + children[i].getXPos() + "," + children[i].getYPos() + ")}{\\texttt{");
                int j = children[i].getStartLabel();
                while (j <= children[i].getEndLabel()) {
                    if (this.text[j] != '$') {
                        this.pw.print(this.text[j]);
                    } else {
                        this.pw.print("\\" + this.text[j]);
                    }
                    ++j;
                }
                this.pw.print("}}\n");
                ++i;
            }
        } else {
            this.pw.print("\\nput{-90}{" + node.getId() + "}{" + (node.getLeafLabel() + 1) + "}\n");
        }
    }

    private String getHeader() {
        String header = "\\documentclass{article}\n\\usepackage{times}\n\\usepackage{pstricks,pst-node,pst-tree,pst-text,pstcol}\n\\usepackage{graphics}\n\\oddsidemargin=0cm\n\\evensidemargin=0cm\n\\textwidth=16cm\n\\textheight=22cm\n\\begin{document}\n";
        return header;
    }

    private String getFooter() {
        String footer = "\\end{document}";
        return footer;
    }

    private void localizeLeaves(SuffixNode node) {
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.localizeLeaves(children[i]);
                ++i;
            }
            node.setYPos(children[0].getYPos() + 1.0f);
        } else {
            node.setXPos(this.xPos++);
        }
    }

    public int getGraphicType() {
        return this.graphicType;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setGraphicType(int graphicType) {
        this.graphicType = graphicType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }
}

