/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class GeneralizedNode {
    private GeneralizedNode parent = null;
    private GeneralizedNode suffixLink = null;
    private TreeMap children = null;
    private int leafLabel = -1;
    private int endLabel = -1;
    private int startLabel = -1;
    private int matchEnd = -1;
    private int nodeDepth = 0;
    private int id = nextId++;
    private boolean leaf = true;
    private int stringId = 0;
    private static int nextId = 1;

    public GeneralizedNode() {
    }

    public GeneralizedNode(GeneralizedNode parent, int startLabel, int endLabel) {
        this.parent = parent;
        this.startLabel = startLabel;
        this.endLabel = endLabel;
    }

    public GeneralizedNode(GeneralizedNode parent, int startLabel) {
        this.parent = parent;
        this.startLabel = startLabel;
    }

    public GeneralizedNode getChild(char c) {
        if (this.children != null) {
            return (GeneralizedNode)this.children.get(new Character(c));
        }
        return null;
    }

    public void addChild(char c, GeneralizedNode node) {
        if (this.children == null) {
            this.children = new TreeMap();
            this.leaf = false;
        }
        this.children.put(new Character(c), node);
    }

    public void removeChild(char c) {
        this.children.remove(new Character(c));
    }

    public static int getNextId() {
        return nextId;
    }

    public GeneralizedNode[] getChildren() {
        Collection collection = this.children.values();
        GeneralizedNode[] nodes = new GeneralizedNode[collection.size()];
        Iterator iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            nodes[i++] = (GeneralizedNode)iterator.next();
        }
        return nodes;
    }

    public int getEndLabel() {
        return this.endLabel;
    }

    public int getId() {
        return this.id;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public int getMatchEnd() {
        return this.matchEnd;
    }

    public GeneralizedNode getParent() {
        return this.parent;
    }

    public int getStartLabel() {
        return this.startLabel;
    }

    public void setEndLabel(int endLabel) {
        this.endLabel = endLabel;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public void setMatchEnd(int matchEnd) {
        this.matchEnd = matchEnd;
    }

    public void setParent(GeneralizedNode parent) {
        this.parent = parent;
    }

    public void setStartLabel(int startLabel) {
        this.startLabel = startLabel;
    }

    public int getLeafLabel() {
        return this.leafLabel;
    }

    public void setLeafLabel(int leafLabel) {
        this.leafLabel = leafLabel;
    }

    public GeneralizedNode getSuffixLink() {
        return this.suffixLink;
    }

    public void setSuffixLink(GeneralizedNode suffixLink) {
        this.suffixLink = suffixLink;
    }

    public int getNodeDepth() {
        return this.nodeDepth;
    }

    public void setNodeDepth(int nodeDepth) {
        this.nodeDepth = nodeDepth;
    }

    public int getStringId() {
        return this.stringId;
    }

    public void setStringId(int stringId) {
        this.stringId = stringId;
    }
}

