/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import haubold.stringmatching.suffixtree.algorithms.SuffixNode;
import haubold.stringmatching.suffixtree.algorithms.SuffixTree;
import haubold.stringmatching.suffixtree.algorithms.TreeMonitor;
import java.util.ArrayList;

public class NaiveSuffixTree
implements SuffixTree {
    SuffixNode root;
    char[] text;
    int textIndex = 0;
    TreeMonitor monitor;
    boolean debug = false;
    ArrayList matchList;

    public NaiveSuffixTree() {
        if (this.debug) {
            this.monitor = new TreeMonitor();
        }
        this.matchList = new ArrayList();
    }

    public SuffixNode constructSuffixTree(char[] text) {
        this.text = text;
        int lastIndex = text.length - 1;
        this.initialize();
        this.generateDebugOutput();
        this.textIndex = 1;
        while (this.textIndex < text.length - 1) {
            this.root = this.insertSuffix(this.root, this.textIndex);
            this.generateDebugOutput();
            ++this.textIndex;
        }
        return this.root;
    }

    private SuffixNode initialize() {
        this.root = new SuffixNode(null, 0, -1);
        SuffixNode leaf = new SuffixNode(this.root, 0, this.text.length - 1);
        leaf.setLeafLabel(0);
        leaf.setParent(this.root);
        this.root.addChild(this.text[0], leaf);
        return this.root;
    }

    private SuffixNode insertSuffix(SuffixNode node, int suffixIndex) {
        boolean suffixIncrement = false;
        if (node.getChild(this.text[suffixIndex]) == null) {
            this.insertNode(node, suffixIndex, -1);
            return node;
        }
        node = node.getChild(this.text[suffixIndex]);
        int i = 0;
        while (this.text[node.getStartLabel() + i] == this.text[suffixIndex]) {
            ++suffixIndex;
            if (node.getStartLabel() + ++i <= node.getEndLabel()) continue;
            if (node.getChild(this.text[suffixIndex]) == null) break;
            node = node.getChild(this.text[suffixIndex]);
            i = 0;
        }
        --i;
        --suffixIndex;
        String edgeLabel = new String();
        int j = node.getStartLabel();
        while (j <= node.getEndLabel()) {
            edgeLabel = String.valueOf(edgeLabel) + this.text[j];
            ++j;
        }
        this.insertNode(node, suffixIndex, node.getStartLabel() + i);
        return this.root;
    }

    private void insertNode(SuffixNode node, int suffixIndex, int edgeEnd) {
        if (node.getParent() == null) {
            SuffixNode leaf = new SuffixNode(node, suffixIndex, this.text.length - 1);
            leaf.setLeafLabel(this.textIndex);
            node.addChild(this.text[suffixIndex], leaf);
            leaf.setParent(node);
            return;
        }
        if (node.getEndLabel() == edgeEnd) {
            SuffixNode leaf = new SuffixNode(node, suffixIndex + 1, this.text.length - 1);
            leaf.setLeafLabel(this.textIndex);
            node.addChild(this.text[suffixIndex + 1], leaf);
            leaf.setParent(node);
            return;
        }
        if (node.getEndLabel() > edgeEnd) {
            SuffixNode internalNode = new SuffixNode(node.getParent(), node.getStartLabel(), edgeEnd);
            node.getParent().removeChild(this.text[node.getStartLabel()]);
            node.setStartLabel(edgeEnd + 1);
            internalNode.addChild(this.text[node.getStartLabel()], node);
            node.getParent().addChild(this.text[internalNode.getStartLabel()], internalNode);
            node.setParent(internalNode);
            SuffixNode leaf = new SuffixNode(internalNode, suffixIndex + 1, this.text.length - 1);
            internalNode.addChild(this.text[suffixIndex + 1], leaf);
            leaf.setLeafLabel(this.textIndex);
            leaf.setParent(internalNode);
            return;
        }
        System.out.println("ERROR: insertion of node " + node.getId() + " failed." + " node.getEndLabel(): " + node.getEndLabel() + " edgeEnd: " + edgeEnd + " suffixIndex: " + suffixIndex);
    }

    private void generateDebugOutput() {
        if (this.debug) {
            System.out.println("*********** Tree" + this.textIndex + "****************");
            this.monitor.writeTree(this.root);
            System.out.println("************************");
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (debug && this.monitor == null) {
            this.monitor = new TreeMonitor();
        }
    }

    public char[] getText() {
        return this.text;
    }

    public SuffixNode getRoot() {
        return this.root;
    }

    public ArrayList match(char[] pattern) {
        int pi = 0;
        SuffixNode node = this.root;
        if (node.getChild(pattern[0]) == null) {
            int[] m = new int[]{};
            return this.matchList;
        }
        node = node.getChild(pattern[0]);
        int i = 0;
        while (pi < pattern.length && this.text[node.getStartLabel() + i] == pattern[pi]) {
            ++pi;
            if (node.getStartLabel() + ++i <= node.getEndLabel()) continue;
            if (pi >= pattern.length || node.getChild(pattern[pi]) == null) break;
            node = node.getChild(pattern[pi]);
            i = 0;
        }
        --i;
        this.matchList.clear();
        if (--pi == pattern.length - 1) {
            this.searchLeaves(node);
        }
        return this.matchList;
    }

    private void searchLeaves(SuffixNode node) {
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.searchLeaves(children[i]);
                ++i;
            }
        } else {
            this.matchList.add(new Integer(node.getLeafLabel()));
        }
    }
}

