/*
 * Decompiled with CFR 0.152.
 */
package haubold.coalescent;

import haubold.coalescent.Mutation;
import haubold.coalescent.MutationObject;
import haubold.coalescent.Node;
import haubold.coalescent.NumericalTools;
import java.util.Random;

public class Tree {
    private Node[] tree;
    int sampleSize;
    double[][] treeCoord;
    double[][] haplotypes;
    double pos;
    double ranPos;
    double theta;
    double totalMutations;
    Mutation[] mutations;
    NumericalTools nt = new NumericalTools();
    Random randomNumber = new Random();

    public void makeTree(int n) {
        this.sampleSize = n;
        double t = 0.0;
        int doubleSampleSize = 2 * this.sampleSize;
        this.tree = new Node[doubleSampleSize - 1];
        int[] list = new int[this.sampleSize];
        int i = 0;
        while (i < 2 * this.sampleSize - 1) {
            this.tree[i] = new Node();
            ++i;
        }
        i = 0;
        while (i < this.sampleSize) {
            this.tree[i].time = 0.0;
            this.tree[i].desc1 = null;
            this.tree[i].desc2 = null;
            this.tree[i].numMut = 0;
            this.tree[i].id = i;
            ++i;
        }
        this.tree[doubleSampleSize - 2].ancestor = null;
        i = this.sampleSize;
        while (i > 1) {
            this.tree[doubleSampleSize - i].time = t += -2.0 * Math.log(1.0 - this.randomNumber.nextDouble()) / (double)(i * (i - 1));
            --i;
        }
        i = 0;
        while (i < this.sampleSize) {
            list[i] = i;
            ++i;
        }
        i = this.sampleSize;
        while (i > 1) {
            int pick = (int)(this.randomNumber.nextDouble() * (double)i);
            this.tree[list[pick]].ancestor = this.tree[doubleSampleSize - i];
            this.tree[doubleSampleSize - i].desc1 = this.tree[list[pick]];
            list[pick] = list[i - 1];
            pick = (int)(this.randomNumber.nextDouble() * ((double)i - 1.0));
            this.tree[list[pick]].ancestor = this.tree[doubleSampleSize - i];
            this.tree[doubleSampleSize - i].desc2 = this.tree[list[pick]];
            list[pick] = doubleSampleSize - i;
            --i;
        }
        this.pos = 0.0;
        this.totalMutations = 0.0;
        this.detX(this.tree[2 * this.sampleSize - 2]);
    }

    public double[][] getTreeCoordinates() {
        this.treeCoord = new double[2 * this.sampleSize - 1][4];
        int i = 0;
        while (i < 2 * this.sampleSize - 1) {
            if (this.tree[i].ancestor != null) {
                this.treeCoord[i][0] = this.tree[i].xPos;
                this.treeCoord[i][1] = this.tree[i].time;
                this.treeCoord[i][2] = this.tree[i].ancestor.xPos;
                this.treeCoord[i][3] = this.tree[i].ancestor.time;
            }
            ++i;
        }
        return this.treeCoord;
    }

    public void mutate(double tc) {
        this.theta = tc;
        this.detMut(this.tree[2 * this.sampleSize - 2]);
    }

    private void detX(Node localRoot) {
        if (localRoot != null) {
            this.detX(localRoot.desc1);
            localRoot.xPos = this.pos;
            this.pos += 1.0;
            this.detX(localRoot.desc2);
        }
    }

    private void detMut(Node localRoot) {
        if (localRoot != null) {
            this.detMut(localRoot.desc1);
            if (localRoot.ancestor != null) {
                localRoot.mutations = NumericalTools.nextPoisson(this.theta / 2.0 * (localRoot.ancestor.time - localRoot.time));
                this.totalMutations += localRoot.mutations;
            }
            this.detMut(localRoot.desc2);
        }
    }

    public MutationObject getMutationCoordinates() {
        MutationObject mo = new MutationObject();
        int mut = 0;
        double[][] mutCoord = new double[(int)this.totalMutations][2];
        double[][] haplotypes = new double[this.sampleSize][(int)this.totalMutations];
        int i = 0;
        while (i < 2 * this.sampleSize - 1) {
            if (this.tree[i].mutations > 0.0) {
                int m = (int)this.tree[i].mutations;
                double deltaX = this.tree[i].xPos - this.tree[i].ancestor.xPos;
                double deltaY = this.tree[i].ancestor.time - this.tree[i].time;
                int j = 0;
                while (j < m) {
                    this.ranPos = this.randomNumber.nextDouble();
                    this.makeHaplotypes(this.tree[i], haplotypes, mut);
                    this.ranPos = this.randomNumber.nextDouble();
                    mutCoord[mut][0] = this.tree[i].xPos - deltaX * this.ranPos;
                    if (deltaX < 0.0) {
                        mutCoord[mut][0] = mutCoord[mut][0] * 0.99;
                    }
                    mutCoord[mut][1] = this.tree[i].time + deltaY * this.ranPos;
                    ++mut;
                    ++j;
                }
            }
            ++i;
        }
        mo.mutCoord = mutCoord;
        mo.haplotypes = haplotypes;
        return mo;
    }

    private void makeHaplotypes(Node localRoot, double[][] haplotypes, int mut) {
        if (localRoot != null) {
            this.makeHaplotypes(localRoot.desc1, haplotypes, mut);
            if (localRoot.desc1 == null) {
                haplotypes[localRoot.id][mut] = this.ranPos;
            }
            this.makeHaplotypes(localRoot.desc2, haplotypes, mut);
        }
    }

    public int[] getLeafId() {
        int[] leafId = new int[this.sampleSize];
        this.pos = 0.0;
        this.computeLeafId(this.tree[2 * this.sampleSize - 2], leafId);
        return leafId;
    }

    private void computeLeafId(Node localRoot, int[] leafId) {
        if (localRoot != null) {
            this.computeLeafId(localRoot.desc1, leafId);
            if (localRoot.desc1 == null) {
                leafId[(int)this.pos] = localRoot.id;
                this.pos += 1.0;
            }
            this.computeLeafId(localRoot.desc2, leafId);
        }
    }
}

