/*
 * Decompiled with CFR 0.152.
 */
package haubold.coalescent;

import haubold.coalescent.Mutation;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TreePanel
extends JPanel
implements MouseMotionListener {
    double[][] treeCoords;
    double[][] mutCoords;
    int[] leafId;
    boolean tree = false;
    boolean mutations = false;
    int w = 400;
    int h = 200;
    int border = this.w / 10;
    int nodes;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    ArrayList mutationList = new ArrayList();
    Rectangle hitRect = new Rectangle(0, 0, 3, 3);
    double scale;
    double xTranslate;
    double yTranslate;
    Mutation[] mutationArray;

    public void reset() {
        this.repaint();
    }

    public void drawTree(double[][] tc, int[] li) {
        this.treeCoords = tc;
        this.leafId = li;
        this.tree = true;
        this.repaint();
    }

    public void drawMutations(double[][] mc) {
        this.mutCoords = mc;
        this.mutations = true;
        this.repaint();
    }

    public void paint(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double unitX = 1.0;
        double unitY = 1.0;
        double unitLeaves = 1.0;
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(this.bgc.getColor1());
        g2.fill(rectangle);
        g2.setPaint(Color.blue);
        double highestP = 0.0;
        AffineTransform transform = g2.getTransform();
        double xScale = (double)this.getWidth() / (double)this.w;
        double yScale = (double)this.getHeight() / (double)this.h;
        double scale = Math.min(xScale, yScale);
        this.xTranslate = ((double)this.getWidth() - (double)this.w * scale) / 2.0;
        this.yTranslate = ((double)this.getHeight() - (double)this.h * scale) / 2.0;
        g2.translate(this.xTranslate, this.yTranslate);
        g2.scale(scale, scale);
        if (this.tree) {
            this.nodes = this.treeCoords.length;
            int sampleSize = (this.nodes + 1) / 2;
            i = 0;
            while (i < this.nodes) {
                if (this.treeCoords[i][3] > highestP) {
                    highestP = this.treeCoords[i][3];
                }
                ++i;
            }
            unitX = ((double)this.w - 4.0 * (double)this.border) / (double)(this.nodes - 1);
            unitLeaves = (double)(this.w - 4 * this.border) / (double)((this.nodes + 1) / 2 - 1);
            unitY = ((double)this.h - 2.0 * (double)this.border) / 3.0;
            yScale = highestP * unitY > (double)(this.h - this.border) ? (double)(this.h - 2 * this.border) / (highestP * unitY) : 1.0;
            g2.setPaint(Color.black);
            g2.setFont(new Font("Times", 0, 10));
            g2.drawLine(10, this.h - this.border, 10, (int)((double)(this.h - this.border) - unitY * yScale));
            g2.drawLine(8, this.h - this.border, 12, this.h - this.border);
            g2.drawLine(8, (int)((double)(this.h - this.border) - unitY * yScale), 12, (int)((double)(this.h - this.border) - unitY * yScale));
            g2.drawString("2N generations", 14, (int)((double)(this.h - this.border) - unitY * yScale / 2.0 + 3.0));
            g2.translate(100, 0);
            g2.setPaint(Color.black);
            if (sampleSize < 16) {
                i = 0;
                while (i < sampleSize) {
                    g2.drawString(String.valueOf(this.leafId[i] + 1), (int)((double)(this.border / 2) + (double)i * unitLeaves) - 2, this.h - 30);
                    ++i;
                }
            }
            g2.setPaint(Color.blue);
            i = 0;
            while (i < this.nodes) {
                g2.drawLine((int)((double)(this.border / 2) + this.treeCoords[i][0] * unitX), (int)((double)(this.h - this.border) - this.treeCoords[i][1] * unitY * yScale), (int)((double)(this.border / 2) + this.treeCoords[i][2] * unitX), (int)((double)(this.h - this.border) - this.treeCoords[i][3] * unitY * yScale));
                ++i;
            }
        }
        if (this.mutations) {
            this.mutationList.clear();
            g2.setPaint(Color.red);
            int mut = this.mutCoords.length;
            i = 0;
            while (i < mut) {
                Rectangle2D.Float dot = new Rectangle2D.Float((int)((double)(this.border / 2) + this.mutCoords[i][0] * unitX), (int)((double)(this.h - this.border) - this.mutCoords[i][1] * unitY * yScale), 2.0f, 2.0f);
                this.mutationList.add(dot);
                g2.fill(dot);
                ++i;
            }
        }
        g2.setTransform(transform);
    }

    public void setTree(boolean t) {
        this.tree = t;
    }

    public void setMutations(boolean m) {
        this.mutations = m;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.hitRect.x = (int)(((double)e.getX() - this.xTranslate) / this.scale);
        this.hitRect.y = (int)(((double)e.getY() - this.yTranslate) / this.scale);
        int n = this.mutationList.size();
        int i = 0;
        while (i < n) {
            if (((Shape)this.mutationList.get(i)).intersects(this.hitRect)) {
                // empty if block
            }
            ++i;
        }
    }

    public void setMutationArray(Mutation[] mutationArray) {
        this.mutationArray = mutationArray;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        int i = 0;
        while (i < mutationArray.length) {
            ++i;
        }
    }
}

