/*
 * Decompiled with CFR 0.152.
 */
package haubold.dp;

import haubold.dp.DynamicProgramming;
import haubold.dp.GapModel;
import haubold.dp.SubstitutionMatrix;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class PairwiseAlignmentDemo
extends DemoFrame {
    JTextField seqField1;
    JTextField seqField2;
    JTextField gapOpeningField;
    JTextField gapExtensionField;
    JTextField alignmentField1;
    JTextField alignmentField2;
    JToolBar toolBar;
    JComboBox alignmentBox;
    JButton resetButton;
    JButton stepButton;
    GapModel gapModel;
    JLabel gapCostLabel;
    JLabel plusLabel;
    JLabel gapLengthLabel;
    JLabel seqLabel1;
    JLabel seqLabel2;
    JLabel scoreLabel;
    SubstitutionMatrix sMatrix;
    static JFrame appletFrame;
    DynamicProgramming dp;
    String[] alignment = new String[3];
    String initialSeq1;
    String initialSeq2;
    JTextArea textArea;
    JScrollPane textPane;
    JSlider matchSlider;
    JSlider mismatchSlider;
    JSlider gapSlider;
    JPanel textPanel;
    JPanel sequencePanel1;
    JPanel sequencePanel2;
    JPanel sequencePanel;
    JPanel controlPanel;
    JPanel sliderPanel;
    JPanel alignmentPanel;
    PrintableJPanel displayPanel;
    int step;
    Font font10;
    Font font12;
    boolean global = false;
    boolean local = false;
    boolean overlap = false;
    JLabel[][] alignmentField;
    Border border;
    int initialMismatch = -3;
    int initialMatch = 4;
    int initialGap = -5;

    public PairwiseAlignmentDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.setTitle("Pairwise Alignment");
        this.font12 = new Font("CourierNew", 0, 12);
        this.font10 = new Font("CourierNew", 0, 10);
        this.seqLabel1 = new JLabel(" Sequence 1 ");
        this.seqLabel2 = new JLabel(" Sequence 2 ");
        this.initialSeq1 = "ACCGTT";
        this.initialSeq2 = "AGTTAC";
        this.seqField1 = new JTextField(this.initialSeq1, 40);
        this.seqField2 = new JTextField(this.initialSeq2, 40);
        this.seqField1.setFont(this.font12);
        this.seqField2.setFont(this.font12);
        this.sequencePanel1 = new JPanel(new BorderLayout());
        this.sequencePanel2 = new JPanel(new BorderLayout());
        this.sequencePanel = new JPanel(new BorderLayout());
        this.sequencePanel1.add((Component)this.seqLabel1, "West");
        this.sequencePanel1.add((Component)this.seqField1, "Center");
        this.sequencePanel2.add((Component)this.seqLabel2, "West");
        this.sequencePanel2.add((Component)this.seqField2, "Center");
        this.sequencePanel.add((Component)this.sequencePanel1, "North");
        this.sequencePanel.add((Component)this.sequencePanel2, "South");
        this.gapModel = new GapModel();
        String[] str1 = new String[]{"Global Alignment Algorithm", "Local Alignment Algorithm", "Overlap Alignment Algorithm"};
        this.alignmentBox = new JComboBox<String>(str1);
        this.alignmentBox.setForeground(Color.black);
        this.stepButton = new JButton(Icons.get2rightArrow());
        this.stepButton.setToolTipText("Step 1: setup matrix");
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PairwiseAlignmentDemo.this.stepAction();
            }
        });
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PairwiseAlignmentDemo.this.resetAction();
            }
        });
        this.sMatrix = new SubstitutionMatrix();
        this.sMatrix.setToolTipText("Substitution Matrix");
        BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
        this.toolBar = new JToolBar();
        this.toolBar.add(this.stepButton);
        this.toolBar.add(this.resetButton);
        this.toolBar.add(this.alignmentBox);
        this.sliderPanel = new JPanel(new GridLayout(1, 3));
        this.matchSlider = bgc.getSlider(-5, 5, this.initialMatch, "Match Score");
        this.matchSlider.setMinorTickSpacing(1);
        this.matchSlider.setSnapToTicks(true);
        this.mismatchSlider = bgc.getSlider(-5, 5, this.initialMismatch, "Mismatch Score");
        this.mismatchSlider.setMinorTickSpacing(1);
        this.mismatchSlider.setSnapToTicks(true);
        this.gapSlider = bgc.getSlider(-5, 5, this.initialGap, "Gap Extension");
        this.gapSlider.setMinorTickSpacing(1);
        this.gapSlider.setSnapToTicks(true);
        this.sliderPanel.add(this.matchSlider);
        this.sliderPanel.add(this.mismatchSlider);
        this.sliderPanel.add(this.gapSlider);
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.add((Component)this.toolBar, "North");
        inputPanel.add((Component)this.sliderPanel, "Center");
        inputPanel.add((Component)this.sequencePanel, "South");
        this.alignmentPanel = new JPanel(new BorderLayout());
        this.scoreLabel = new JLabel(" Score = ");
        this.scoreLabel.setFont(this.font12);
        this.scoreLabel.setOpaque(true);
        this.scoreLabel.setBackground(bgc.getColor1());
        this.scoreLabel.setForeground(Color.black);
        Font font = new Font("CourierNew", 0, 12);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(3, 100));
        textPanel.setBackground(bgc.getColor2());
        textPanel.setForeground(Color.blue);
        this.alignmentField = new JLabel[3][50];
        int j = 0;
        while (j < 3) {
            int i = 0;
            while (i < this.alignmentField[0].length) {
                this.alignmentField[j][i] = new JLabel(" ");
                this.alignmentField[j][i].setHorizontalAlignment(0);
                textPanel.add(this.alignmentField[j][i]);
                textPanel.setBorder(this.border);
                ++i;
            }
            ++j;
        }
        this.alignmentPanel.add((Component)textPanel, "North");
        this.alignmentPanel.add((Component)this.scoreLabel, "South");
        this.dp = new DynamicProgramming(this.initialSeq1, this.initialSeq2);
        this.dp.setPreferredSize(new Dimension(200, 200));
        this.step = 0;
        this.stepAction();
        this.displayPanel = new PrintableJPanel();
        this.displayPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.displayPanel.add((Component)inputPanel, "North");
        this.displayPanel.add((Component)this.dp, "Center");
        this.displayPanel.add((Component)this.alignmentPanel, "South");
        this.getContentPane().add((Component)this.displayPanel, "Center");
        this.getFileMenu().getPrintMenuItem().setPrintable(this.displayPanel);
    }

    private void resetAction() {
        this.seqField1.setText(this.initialSeq1);
        this.seqField2.setText(this.initialSeq2);
        this.gapModel.setGapOpening(0.0);
        this.gapModel.setGapExtension(-1.0);
        this.alignmentBox.setSelectedIndex(0);
        this.matchSlider.setValue(this.initialMatch);
        this.mismatchSlider.setValue(this.initialMismatch);
        this.gapSlider.setValue(this.initialGap);
        this.sMatrix.reset();
        this.step = 0;
        this.stepAction();
    }

    private void stepAction() {
        if (this.step == 0) {
            this.dp.setSequences(this.seqField1.getText(), this.seqField2.getText());
            this.stepButton.setToolTipText("Step 1: setup matrix");
            this.scoreLabel.setText(" ");
            int j = 0;
            while (j < 3) {
                int i = 0;
                while (i < this.alignmentField[0].length) {
                    this.alignmentField[j][i].setText(" ");
                    ++i;
                }
                ++j;
            }
            this.seqField1.setEditable(true);
            this.seqField2.setEditable(true);
            this.alignmentBox.setEnabled(true);
            this.matchSlider.setEnabled(true);
            this.mismatchSlider.setEnabled(true);
            this.gapSlider.setEnabled(true);
            ++this.step;
            this.dp.setAlignmentMode(this.dp.CLEAR_MATRIX);
            this.dp.repaint();
        } else if (this.step == 1) {
            this.global = false;
            this.local = false;
            this.overlap = false;
            String message = "ok";
            if (message.equals("ok")) {
                this.dp.setSequences(this.seqField1.getText(), this.seqField2.getText());
                try {
                    HashMap hm = this.sMatrix.getValues();
                }
                catch (NumberFormatException e) {
                    JOptionPane optionPane = new JOptionPane("Please enter only numbers in substitution matrix.", 0);
                    JDialog dialog = optionPane.createDialog(optionPane, "Error in Substitution Matrix");
                    dialog.setVisible(true);
                    return;
                }
            } else {
                JOptionPane optionPane = new JOptionPane(message, 0);
                JDialog dialog = optionPane.createDialog(optionPane, "Error in Sequence");
                dialog.setVisible(true);
                return;
            }
            this.dp.setMatchScore(this.matchSlider.getValue());
            this.dp.setMismatchScore(this.mismatchSlider.getValue());
            this.dp.setGapExtension(this.gapSlider.getValue());
            this.stepButton.setToolTipText("Step 2: initialize matrix");
            ++this.step;
            this.matchSlider.setEnabled(false);
            this.mismatchSlider.setEnabled(false);
            this.gapSlider.setEnabled(false);
            this.seqField1.setEditable(false);
            this.seqField2.setEditable(false);
            this.alignmentBox.setEnabled(false);
            if (this.alignmentBox.getSelectedItem().toString().equals("Global Alignment Algorithm")) {
                this.global = true;
            } else if (this.alignmentBox.getSelectedItem().toString().equals("Overlap Alignment Algorithm")) {
                this.overlap = true;
            } else if (this.alignmentBox.getSelectedItem().toString().equals("Local Alignment Algorithm")) {
                this.local = true;
            }
            if (this.global) {
                this.dp.initializeGlobalAlignment();
                this.dp.fillGlobalAlignment();
                this.alignment = this.dp.traceBackGlobalAlignment();
            } else if (this.overlap) {
                this.dp.initializeOverlapAlignment();
                this.dp.fillOverlapAlignment();
                this.alignment = this.dp.traceBackOverlapAlignment();
            } else if (this.local) {
                this.dp.initializeLocalAlignment();
                this.dp.fillLocalAlignment();
                this.alignment = this.dp.traceBackLocalAlignment();
            }
            this.dp.setAlignmentMode(this.dp.SETUP_MATRIX);
            this.dp.repaint();
        } else if (this.step == 2) {
            this.dp.setAlignmentMode(this.dp.INITIALIZE_MATRIX);
            this.dp.repaint();
            this.stepButton.setToolTipText("Step 3: fill matrix      ");
            ++this.step;
        } else if (this.step == 3) {
            this.stepButton.setToolTipText("Step 4: trace back       ");
            this.dp.setAlignmentMode(this.dp.FILL_MATRIX);
            this.dp.repaint();
            ++this.step;
        } else if (this.step == 4) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < Math.min(this.alignment[i].length(), this.alignmentField[0].length)) {
                    this.alignmentField[i][j].setText(this.alignment[i].substring(j, j + 1));
                    ++j;
                }
                ++i;
            }
            this.stepButton.setToolTipText("Step 5: clear matrix     ");
            if (this.global) {
                this.scoreLabel.setText("Score = " + String.valueOf(this.dp.optimalScore) + "; Number of cooptimal alignments = " + String.valueOf(this.dp.numCooptimal));
            } else {
                this.scoreLabel.setText("Score = " + String.valueOf(this.dp.optimalScore));
            }
            this.dp.setAlignmentMode(this.dp.TRACE_BACK);
            this.dp.repaint();
            this.step = 0;
        } else {
            this.global = false;
            this.local = false;
            this.overlap = false;
            this.step = 0;
        }
    }

    String checkSequences() {
        String s;
        String seq1 = this.seqField1.getText();
        String seq2 = this.seqField2.getText();
        seq1 = seq1.toUpperCase();
        seq2 = seq2.toUpperCase();
        int i = 0;
        while (i < seq1.length()) {
            s = seq1.substring(i, i + 1);
            if (!(s.equals("A") || s.equals("C") || s.equals("T") || s.equals("G"))) {
                String message = "Sequence 1 contains an error at position " + String.valueOf(++i);
                return message;
            }
            ++i;
        }
        i = 0;
        while (i < seq2.length()) {
            s = seq2.substring(i, i + 1);
            if (!(s.equals("A") || s.equals("C") || s.equals("T") || s.equals("G"))) {
                String message = "Sequence 2 contains an error at position " + String.valueOf(++i);
                return message;
            }
            ++i;
        }
        String message = "ok";
        return message;
    }
}

