/*
 * Decompiled with CFR 0.152.
 */
package haubold.dp;

import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.GridLayout;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SubstitutionMatrix
extends JPanel {
    private JTextField[][] matrixField;
    private HashMap matrixHash = null;
    private String alphabet = "ACGT";
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    private double matchScore;
    private double mismatchScore;

    SubstitutionMatrix() {
        this.matrixField = new JTextField[this.alphabet.length() + 1][this.alphabet.length() + 1];
        this.setLayout(new GridLayout(this.alphabet.length() + 1, this.alphabet.length() + 1));
        int i = 0;
        while (i < this.alphabet.length() + 1) {
            int j = 0;
            while (j < this.alphabet.length() + 1) {
                this.matrixField[i][j] = new JTextField();
                this.matrixField[i][j].setEditable(true);
                this.matrixField[i][j].setHorizontalAlignment(4);
                this.add(this.matrixField[i][j]);
                ++j;
            }
            ++i;
        }
        this.initializeMatrix();
    }

    public void initializeMatrix() {
        int j;
        int i;
        if (this.matrixHash == null) {
            this.matrixHash = new HashMap();
            i = 0;
            while (i < this.alphabet.length()) {
                j = 0;
                while (j < this.alphabet.length()) {
                    if (i == j) {
                        this.matrixHash.put(String.valueOf(this.alphabet.substring(i, i + 1)) + this.alphabet.substring(j, j + 1), new Double(this.matchScore));
                    } else {
                        this.matrixHash.put(String.valueOf(this.alphabet.substring(i, i + 1)) + this.alphabet.substring(j, j + 1), new Double(this.mismatchScore));
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.alphabet.length()) {
            this.matrixField[i + 1][0].setText(this.alphabet.substring(i, i + 1));
            this.matrixField[0][i + 1].setText(this.alphabet.substring(i, i + 1));
            this.matrixField[i + 1][0].setEditable(false);
            this.matrixField[0][i + 1].setEditable(false);
            this.matrixField[i + 1][0].setBackground(this.bgc.getColor2());
            this.matrixField[0][i + 1].setBackground(this.bgc.getColor2());
            j = 0;
            while (j < this.alphabet.length()) {
                this.matrixField[i + 1][j + 1].setText(this.matrixHash.get(String.valueOf(this.alphabet.substring(i, i + 1)) + this.alphabet.substring(j, j + 1)).toString());
                this.matrixField[i + 1][j + 1].setEditable(true);
                ++j;
            }
            ++i;
        }
        this.matrixField[0][0].setBackground(this.bgc.getColor2());
        this.matrixField[0][0].setEditable(false);
    }

    public HashMap getValues() {
        int i = 1;
        while (i < this.matrixField.length) {
            int j = 1;
            while (j < this.matrixField.length) {
                this.matrixHash.put(String.valueOf(this.matrixField[0][j].getText()) + this.matrixField[i][0].getText(), new Double(Double.parseDouble(this.matrixField[i][j].getText())));
                ++j;
            }
            ++i;
        }
        return this.matrixHash;
    }

    public void setValues(HashMap hm) {
        this.matrixHash = hm;
        this.initializeMatrix();
    }

    public String getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(String al) {
        this.alphabet = al;
    }

    public void reset() {
        this.initializeMatrix();
    }

    public void disableEdit() {
        int i = 1;
        while (i < this.alphabet.length() + 1) {
            int j = 1;
            while (j < this.alphabet.length() + 1) {
                this.matrixField[i][j].setEditable(false);
                ++j;
            }
            ++i;
        }
    }

    public void enableEdit() {
        int i = 1;
        while (i < this.alphabet.length() + 1) {
            int j = 1;
            while (j < this.alphabet.length() + 1) {
                this.matrixField[i][j].setEditable(true);
                ++j;
            }
            ++i;
        }
    }

    public double getMatchScore() {
        return this.matchScore;
    }

    public double getMismatchScore() {
        return this.mismatchScore;
    }

    public void setMatchScore(double matchScore) {
        this.matchScore = matchScore;
        this.initializeMatrix();
    }

    public void setMismatchScore(double mismatchScore) {
        this.mismatchScore = mismatchScore;
        this.initializeMatrix();
    }
}

