/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

public class HiddenMarkovModel {
    private int numObservationSymbols;
    private int numStates;
    private double[][] transitionProbabilities;
    private double[][] observationProbabilities;
    private double[] initialProbabilities;

    public HiddenMarkovModel() {
    }

    public HiddenMarkovModel(double[][] transitionProbabilities, double[][] observationProbabilities, double[] initialProbabilities) {
        this.transitionProbabilities = transitionProbabilities;
        this.observationProbabilities = observationProbabilities;
        this.initialProbabilities = initialProbabilities;
    }

    public HiddenMarkovModel copy() {
        int j;
        HiddenMarkovModel newHmm = new HiddenMarkovModel();
        double[] ip = new double[this.getNumStates()];
        double[][] op = new double[this.getNumStates()][this.getNumObservationSymbols()];
        double[][] tp = new double[this.getNumStates()][this.getNumStates()];
        int i = 0;
        while (i < this.getNumStates()) {
            ip[i] = this.getInitialProbabilities()[i];
            ++i;
        }
        i = 0;
        while (i < this.getNumStates()) {
            j = 0;
            while (j < this.getNumStates()) {
                tp[i][j] = this.getTransitionProbabilities()[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.getNumStates()) {
            j = 0;
            while (j < this.getNumObservationSymbols()) {
                op[i][j] = this.getObservationProbabilities()[i][j];
                ++j;
            }
            ++i;
        }
        newHmm.setInitialProbabilities(ip);
        newHmm.setObservationProbabilities(op);
        newHmm.setTransitionProbabilities(tp);
        return newHmm;
    }

    public double[] getInitialProbabilities() {
        return this.initialProbabilities;
    }

    public int getNumObservationSymbols() {
        return this.observationProbabilities[0].length;
    }

    public int getNumStates() {
        return this.transitionProbabilities.length;
    }

    public double[][] getObservationProbabilities() {
        return this.observationProbabilities;
    }

    public double[][] getTransitionProbabilities() {
        return this.transitionProbabilities;
    }

    public void setInitialProbabilities(double[] initialProbabilities) {
        this.initialProbabilities = initialProbabilities;
    }

    public void setObservationProbabilities(double[][] observationProbabilities) {
        this.observationProbabilities = observationProbabilities;
    }

    public void setTransitionProbabilities(double[][] transitionProbabilities) {
        this.transitionProbabilities = transitionProbabilities;
    }
}

