/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

import haubold.hmm.algorithm.HiddenMarkovModel;
import haubold.hmm.algorithm.SequenceUnit;
import java.util.Random;

public class HmmSequence {
    private HiddenMarkovModel hmm;
    private Random ran;

    public HmmSequence() {
        this.ran = new Random();
    }

    public HmmSequence(HiddenMarkovModel hiddenMarkovModel) {
        this.hmm = hiddenMarkovModel;
        this.ran = new Random();
    }

    public SequenceUnit[] generateHmmSequence(int length) {
        SequenceUnit[] s = new SequenceUnit[length];
        s[0] = this.getInitialState();
        s[0] = this.generateSymbol(s[0]);
        s[0] = this.generateNucleotide(s[0]);
        int i = 1;
        while (i < length) {
            s[i] = this.generateState(s[i - 1]);
            s[i] = this.generateSymbol(s[i]);
            s[i] = this.generateNucleotide(s[i]);
            ++i;
        }
        return s;
    }

    private SequenceUnit getInitialState() {
        double accum = 0.0;
        int i = 0;
        while (i < this.hmm.getNumStates()) {
            accum += this.hmm.getInitialProbabilities()[i];
            if (this.ran.nextDouble() < accum) {
                return new SequenceUnit(i);
            }
            ++i;
        }
        return new SequenceUnit(i);
    }

    private SequenceUnit generateSymbol(SequenceUnit s) {
        double accum = 0.0;
        int i = 0;
        while (i < this.hmm.getNumObservationSymbols()) {
            accum += this.hmm.getObservationProbabilities()[s.getHiddenState()][i];
            if (this.ran.nextDouble() < accum) {
                s.setObservedState(i);
                return s;
            }
            ++i;
        }
        return s;
    }

    private SequenceUnit generateNucleotide(SequenceUnit s) {
        double accum = 0.0;
        int i = 0;
        while (i < this.hmm.getNumObservationSymbols()) {
            accum += this.hmm.getObservationProbabilities()[s.getHiddenState()][i];
            if (s.getObservedState() == 0) {
                if (this.ran.nextDouble() < 0.5) {
                    s.setNucleotide("A");
                } else {
                    s.setNucleotide("T");
                }
            } else if (this.ran.nextDouble() < 0.5) {
                s.setNucleotide("C");
            } else {
                s.setNucleotide("G");
            }
            ++i;
        }
        return s;
    }

    private SequenceUnit generateState(SequenceUnit s) {
        double accum = 0.0;
        int i = 0;
        while (i < this.hmm.getNumStates()) {
            accum += this.hmm.getTransitionProbabilities()[s.getHiddenState()][i];
            if (this.ran.nextDouble() < accum) {
                return new SequenceUnit(i);
            }
            ++i;
        }
        return new SequenceUnit(i);
    }

    public void setHmm(HiddenMarkovModel model) {
        this.hmm = model;
    }
}

