/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

import haubold.hmm.algorithm.HiddenMarkovModel;
import haubold.hmm.algorithm.SequenceUnit;

public class Viterbi {
    private SequenceUnit[] sequence;
    private HiddenMarkovModel hmm;
    private double logP;

    public Viterbi() {
    }

    public Viterbi(SequenceUnit[] sequence, HiddenMarkovModel hmm) {
        this.sequence = sequence;
        this.hmm = hmm;
    }

    public SequenceUnit[] getViterbiSequence() {
        double max;
        int length = this.sequence.length;
        int[] s = new int[length];
        double[][] dpm = new double[this.hmm.getNumStates()][length];
        this.hmm = this.generateLogModel(this.hmm);
        int i = 0;
        while (i < this.hmm.getNumStates()) {
            dpm[i][0] = this.hmm.getInitialProbabilities()[i] + this.hmm.getObservationProbabilities()[i][this.sequence[0].getObservedState()];
            ++i;
        }
        double v = dpm[0][0];
        s[0] = 0;
        i = 1;
        while (i < this.hmm.getNumStates()) {
            if (dpm[i][0] > v) {
                s[0] = i;
                v = dpm[i][0];
            }
            ++i;
        }
        i = 1;
        while (i < length) {
            max = -1.7976931348623157E308;
            int j = 0;
            while (j < this.hmm.getNumStates()) {
                dpm[j][i] = -1.7976931348623157E308;
                int k = 0;
                while (k < this.hmm.getNumStates()) {
                    v = dpm[k][i - 1] + this.hmm.getTransitionProbabilities()[k][j];
                    if (v > dpm[j][i]) {
                        dpm[j][i] = v;
                    }
                    ++k;
                }
                double[] dArray = dpm[j];
                int n = i;
                dArray[n] = dArray[n] + this.hmm.getObservationProbabilities()[j][this.sequence[i].getObservedState()];
                if (dpm[j][i] > max) {
                    max = dpm[j][i];
                    s[i] = j;
                }
                ++j;
            }
            ++i;
        }
        max = -1.7976931348623157E308;
        i = 0;
        while (i < this.hmm.getNumStates()) {
            if (dpm[i][length - 1] > max) {
                this.logP = max = dpm[i][length - 1];
                s[length - 1] = i;
            }
            ++i;
        }
        i = 0;
        while (i < s.length) {
            this.sequence[i].setHiddenState(s[i]);
            ++i;
        }
        return this.sequence;
    }

    private HiddenMarkovModel generateLogModel(HiddenMarkovModel hmm) {
        int j;
        HiddenMarkovModel hmm2 = new HiddenMarkovModel();
        double[][] t = new double[hmm.getNumStates()][hmm.getNumObservationSymbols()];
        double[][] o = new double[hmm.getNumStates()][hmm.getNumObservationSymbols()];
        double[] s = new double[hmm.getNumStates()];
        int i = 0;
        while (i < hmm.getNumStates()) {
            j = 0;
            while (j < hmm.getNumStates()) {
                t[i][j] = Math.log(hmm.getTransitionProbabilities()[i][j]);
                ++j;
            }
            ++i;
        }
        hmm2.setTransitionProbabilities(t);
        i = 0;
        while (i < hmm.getNumStates()) {
            j = 0;
            while (j < hmm.getNumObservationSymbols()) {
                o[i][j] = Math.log(hmm.getObservationProbabilities()[i][j]);
                ++j;
            }
            ++i;
        }
        hmm2.setObservationProbabilities(o);
        i = 0;
        while (i < hmm.getNumStates()) {
            s[i] = Math.log(hmm.getInitialProbabilities()[i]);
            ++i;
        }
        hmm2.setInitialProbabilities(s);
        return hmm2;
    }

    public HiddenMarkovModel getHmm() {
        return this.hmm;
    }

    public void setHmm(HiddenMarkovModel hmm) {
        this.hmm = hmm;
    }

    public double getLogP() {
        return this.logP;
    }

    public void setSequence(SequenceUnit[] units) {
        this.sequence = units;
    }
}

