/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.algorithm;

import haubold.hmm.algorithm.HiddenMarkovModel;

public class XiGamma {
    private double[][][] xi;
    private double[][] gamma;

    public void computeXiGamma(double[][] forwardProbabilities, double[][] backwardProbabilities, HiddenMarkovModel hmm, int[] observedStates) {
        this.xi = this.computeXi(forwardProbabilities, backwardProbabilities, hmm, observedStates);
        this.gamma = this.computeGamma(forwardProbabilities, backwardProbabilities, hmm, observedStates);
    }

    private double[][][] computeXi(double[][] forwardProbabilities, double[][] backwardProbabilities, HiddenMarkovModel hmm, int[] observedStates) {
        int length = observedStates.length;
        int n = hmm.getNumStates();
        double[][][] xi = new double[n][n][length];
        int i = 0;
        while (i < length - 1) {
            int k;
            double denominator = 0.0;
            int j = 0;
            while (j < n) {
                k = 0;
                while (k < n) {
                    xi[j][k][i] = forwardProbabilities[j][i] * hmm.getTransitionProbabilities()[j][k] * hmm.getObservationProbabilities()[k][observedStates[i + 1]] * backwardProbabilities[k][i + 1];
                    denominator += xi[j][k][i];
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < n) {
                k = 0;
                while (k < n) {
                    double[] dArray = xi[j][k];
                    int n2 = i;
                    dArray[n2] = dArray[n2] / denominator;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return xi;
    }

    private double[][] computeGamma(double[][] forwardProbabilities, double[][] backwardProbabilities, HiddenMarkovModel hmm, int[] observedStates) {
        int length = observedStates.length;
        int n = hmm.getNumStates();
        double[][] gamma = new double[n][length];
        int i = 0;
        while (i < length) {
            double denominator = 0.0;
            int j = 0;
            while (j < n) {
                gamma[j][i] = forwardProbabilities[j][i] * backwardProbabilities[j][i];
                denominator += gamma[j][i];
                ++j;
            }
            j = 0;
            while (j < n) {
                double[] dArray = gamma[j];
                int n2 = i;
                dArray[n2] = dArray[n2] / denominator;
                ++j;
            }
            ++i;
        }
        return gamma;
    }

    public double[][] getGamma() {
        return this.gamma;
    }

    public double[][][] getXi() {
        return this.xi;
    }
}

