/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.gui;

import haubold.hmm.algorithm.HiddenMarkovModel;
import haubold.hmm.algorithm.HmmSequence;
import haubold.hmm.algorithm.SequenceUnit;
import haubold.hmm.algorithm.Viterbi;
import haubold.hmm.gui.HmmPane;
import haubold.hmm.gui.ModelPanel;
import haubold.hmm.gui.SliderPanel;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.Icons;
import haubold.resources.util.LineNumber;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SequencePanel
extends PrintableJPanel {
    private JToolBar toolBar;
    private JSlider itSlider;
    private JButton generateButton;
    private JButton viterbiButton;
    private JButton resetButton;
    private JSplitPane modelPane;
    private JSplitPane combinedPane;
    private ModelPanel modelPanel;
    private SliderPanel sliderPanel;
    private HmmPane hmmPane;
    private HmmPane viterbiPane;
    private JScrollPane hmmScrollPane;
    private JScrollPane viterbiScrollPane;
    private HmmSequence hmmSequence;
    private Viterbi viterbi;
    private BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    private SequenceUnit[] sequenceData;
    private JLabel lengthLabel;

    public SequencePanel() {
        this.hmmPane = new HmmPane();
        this.hmmPane.setToolTipText("True Hidden States");
        this.hmmScrollPane = new JScrollPane(this.hmmPane);
        LineNumber lineNumber1 = new LineNumber(this.hmmPane);
        lineNumber1.setBackground(this.bgc.getColor1());
        this.hmmScrollPane.setRowHeaderView(lineNumber1);
        this.viterbiPane = new HmmPane();
        this.viterbiPane.setPreferredSize(new Dimension());
        this.viterbiPane.setToolTipText("Reconstructed Hidden States");
        this.viterbiScrollPane = new JScrollPane(this.viterbiPane);
        LineNumber lineNumber2 = new LineNumber(this.viterbiPane);
        lineNumber2.setBackground(this.bgc.getColor1());
        this.viterbiScrollPane.setRowHeaderView(lineNumber2);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new GridLayout(1, 2));
        displayPanel.add(this.hmmScrollPane);
        displayPanel.add(this.viterbiScrollPane);
        this.sliderPanel = new SliderPanel();
        this.modelPanel = new ModelPanel(this.sliderPanel.getHmm());
        this.modelPanel.setBackground(this.bgc.getColor1());
        this.sliderPanel.setModelPanel(this.modelPanel);
        this.modelPane = new JSplitPane(1, this.modelPanel, this.sliderPanel);
        this.modelPane.setOneTouchExpandable(true);
        this.modelPane.setDividerLocation(300);
        this.combinedPane = new JSplitPane(0, this.modelPane, displayPanel);
        this.combinedPane.setOneTouchExpandable(true);
        this.combinedPane.setDividerLocation(200);
        this.toolBar = new JToolBar();
        this.generateButton = new JButton(Icons.get1rightArrow());
        this.generateButton.setToolTipText("Generate Sequence");
        this.generateButton.addActionListener(new GenerateActionListener());
        this.toolBar.add(this.generateButton);
        this.viterbiButton = new JButton(Icons.getQuestionMark());
        this.viterbiButton.setToolTipText("Estimate Hidden States");
        this.viterbiButton.addActionListener(new ViterbiActionListener());
        this.viterbiButton.setEnabled(false);
        this.toolBar.add(this.viterbiButton);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        this.resetButton.setEnabled(true);
        ResetActionListener ral = new ResetActionListener();
        this.resetButton.addActionListener(ral);
        this.toolBar.add(this.resetButton);
        this.itSlider = this.bgc.getSlider(0, 5000, 2000, "Length of Observation Sequence");
        this.itSlider.addChangeListener(new LengthActionListener());
        this.toolBar.add(this.itSlider);
        this.lengthLabel = new JLabel(" " + this.itSlider.getValue());
        this.lengthLabel.setPreferredSize(new Dimension(40, 15));
        this.toolBar.add(this.lengthLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.combinedPane, "Center");
        this.hmmSequence = new HmmSequence();
        this.viterbi = new Viterbi();
    }

    public HiddenMarkovModel getHmm() {
        return this.sliderPanel.getHmm();
    }

    class GenerateActionListener
    implements ActionListener {
        GenerateActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int it = SequencePanel.this.itSlider.getValue();
            SequencePanel.this.hmmSequence.setHmm(SequencePanel.this.sliderPanel.getHmm());
            SequencePanel.this.sequenceData = SequencePanel.this.hmmSequence.generateHmmSequence(it);
            SequencePanel.this.hmmPane.setSequenceData(SequencePanel.this.sequenceData);
            SequencePanel.this.viterbiPane.setText("");
            SequencePanel.this.viterbiButton.setEnabled(true);
            SequencePanel.this.resetButton.setEnabled(true);
        }
    }

    class ViterbiActionListener
    implements ActionListener {
        ViterbiActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SequencePanel.this.viterbi.setHmm(SequencePanel.this.sliderPanel.getHmm());
            SequencePanel.this.viterbi.setSequence(SequencePanel.this.sequenceData);
            SequencePanel.this.sequenceData = SequencePanel.this.viterbi.getViterbiSequence();
            SequencePanel.this.viterbiPane.setSequenceData(SequencePanel.this.sequenceData);
        }
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            SequencePanel.this.sliderPanel.reset();
            SequencePanel.this.viterbiButton.setEnabled(false);
            SequencePanel.this.hmmPane.setText("");
            SequencePanel.this.viterbiPane.setText("");
        }
    }

    class LengthActionListener
    implements ChangeListener {
        LengthActionListener() {
        }

        public void stateChanged(ChangeEvent e) {
            SequencePanel.this.lengthLabel.setText(" " + SequencePanel.this.itSlider.getValue());
        }
    }
}

