/*
 * Decompiled with CFR 0.152.
 */
package haubold.hmm.gui;

import haubold.hmm.algorithm.HiddenMarkovModel;
import haubold.hmm.gui.ModelPanel;
import haubold.resources.util.BirkhaeuserGUIComponents;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel {
    private BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    private JSlider emission1;
    private JSlider transition1;
    private JSlider emission2;
    private JSlider transition2;
    private int factor = 100;
    private JSlider initial;
    private ModelPanel modelPanel;
    private HiddenMarkovModel hmm;
    private HiddenMarkovModel originalHmm;
    private Color colorE1;
    private Color colorE2;
    private Color colorH1;
    private Color colorH2;
    double[][] tp1 = new double[][]{{0.99, 0.01}, {0.05, 0.95}};
    double[][] ep1 = new double[][]{{0.5, 0.5}, {0.8, 0.2}};
    double[] ip1 = new double[]{0.5, 0.5};
    double[][] tp2 = new double[][]{{0.99, 0.01}, {0.05, 0.95}};
    double[][] ep2 = new double[][]{{0.5, 0.5}, {0.8, 0.2}};
    double[] ip2 = new double[]{0.5, 0.5};

    public SliderPanel(HiddenMarkovModel hmm) {
        this.hmm = hmm;
        this.initialize();
    }

    public SliderPanel() {
        this.hmm = new HiddenMarkovModel();
        this.hmm.setInitialProbabilities(this.ip1);
        this.hmm.setTransitionProbabilities(this.tp1);
        this.hmm.setObservationProbabilities(this.ep1);
        this.originalHmm = new HiddenMarkovModel();
        this.originalHmm.setInitialProbabilities(this.ip2);
        this.originalHmm.setObservationProbabilities(this.ep2);
        this.originalHmm.setTransitionProbabilities(this.tp2);
        this.colorE1 = this.bgc.getColor3();
        this.colorE2 = this.bgc.getColor5();
        this.colorH1 = this.bgc.getColor2();
        this.colorH2 = this.bgc.getColor4();
        this.initialize();
    }

    private void initialize() {
        this.emission1 = this.bgc.getSlider(0, this.factor, (int)(this.ep1[0][0] * (double)this.factor), "% Emission Probability 1");
        this.emission2 = this.bgc.getSlider(0, this.factor, (int)(this.ep1[1][0] * (double)this.factor), "% Emission Probability 2");
        this.transition1 = this.bgc.getSlider(0, this.factor, (int)(this.tp1[0][0] * (double)this.factor), "% Transition Probability 1");
        this.transition2 = this.bgc.getSlider(0, this.factor, (int)(this.tp1[1][1] * (double)this.factor), "% Transition Probability 2");
        this.initial = this.bgc.getSlider(0, this.factor, (int)(this.ip1[0] * (double)this.factor), "% Initial Probability");
        SliderListener sl = new SliderListener();
        this.emission1.addChangeListener(sl);
        this.emission2.addChangeListener(sl);
        this.transition1.addChangeListener(sl);
        this.transition2.addChangeListener(sl);
        this.initial.addChangeListener(sl);
        this.setColors();
        this.setLayout(new GridLayout(5, 5));
        this.add(this.emission1);
        this.add(this.emission2);
        this.add(this.transition1);
        this.add(this.transition2);
        this.add(this.initial);
    }

    private void setColors() {
    }

    private void paintLabels(JSlider slider, Color c) {
        Dictionary dic = slider.getLabelTable();
        Enumeration enu = dic.keys();
        while (enu.hasMoreElements()) {
            Object o = enu.nextElement();
            JLabel label = (JLabel)dic.get(o);
            label.setForeground(c);
            dic.put(o, label);
        }
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(5);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setBackground(new Color(230, 230, 230));
    }

    public void reset() {
        this.transition1.setValue((int)(this.originalHmm.getTransitionProbabilities()[0][0] * (double)this.factor));
        this.transition2.setValue((int)(this.originalHmm.getTransitionProbabilities()[1][1] * (double)this.factor));
        this.emission1.setValue((int)(this.originalHmm.getObservationProbabilities()[0][0] * (double)this.factor));
        this.emission2.setValue((int)(this.originalHmm.getObservationProbabilities()[1][0] * (double)this.factor));
        this.initial.setValue((int)(this.originalHmm.getInitialProbabilities()[0] * (double)this.factor));
    }

    public void setModelPanel(ModelPanel panel) {
        this.modelPanel = panel;
    }

    public HiddenMarkovModel getHmm() {
        return this.hmm;
    }

    public void setHmm(HiddenMarkovModel model) {
        this.hmm = model;
    }

    public Color getColorE1() {
        return this.colorE1;
    }

    public Color getColorE2() {
        return this.colorE2;
    }

    public Color getColorH1() {
        return this.colorH1;
    }

    public Color getColorH2() {
        return this.colorH2;
    }

    public void setColorE1(Color color) {
        this.colorE1 = color;
        this.setColors();
    }

    public void setColorE2(Color color) {
        this.colorE2 = color;
        this.setColors();
    }

    public void setColorH1(Color color) {
        this.colorH1 = color;
        this.setColors();
    }

    public void setColorH2(Color color) {
        this.colorH2 = color;
        this.setColors();
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent arg0) {
            double[][] tp = SliderPanel.this.hmm.getTransitionProbabilities();
            double[][] ep = SliderPanel.this.hmm.getObservationProbabilities();
            double[] ip = SliderPanel.this.hmm.getInitialProbabilities();
            tp[0][0] = (double)SliderPanel.this.transition1.getValue() / (double)SliderPanel.this.factor;
            tp[0][1] = 1.0 - tp[0][0];
            tp[1][1] = (double)SliderPanel.this.transition2.getValue() / (double)SliderPanel.this.factor;
            tp[1][0] = 1.0 - tp[1][1];
            ep[0][0] = (double)SliderPanel.this.emission1.getValue() / (double)SliderPanel.this.factor;
            ep[0][1] = 1.0 - ep[0][0];
            ep[1][0] = (double)SliderPanel.this.emission2.getValue() / (double)SliderPanel.this.factor;
            ep[1][1] = 1.0 - ep[1][0];
            ip[0] = (double)SliderPanel.this.initial.getValue() / (double)SliderPanel.this.factor;
            ip[1] = 1.0 - ip[0];
            SliderPanel.this.hmm.setInitialProbabilities(ip);
            SliderPanel.this.hmm.setObservationProbabilities(ep);
            SliderPanel.this.hmm.setTransitionProbabilities(tp);
            SliderPanel.this.modelPanel.setHmm(SliderPanel.this.hmm);
        }
    }
}

