/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.distance;

import haubold.phylogeny.distance.Alignment;
import haubold.phylogeny.distance.DistanceComputation;
import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.DataContainer;
import haubold.resources.util.Icons;
import haubold.resources.util.PrintableJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;

public class DistanceComputationGUI
extends PrintableJPanel {
    JToolBar toolBar;
    JButton runButton;
    JButton resetButton;
    JComboBox comboBox;
    JTextPane alignmentPane1;
    JTextPane alignmentPane2;
    JTextPane distancePane;
    JScrollPane alignmentScroll;
    JScrollPane distanceScroll;
    JSplitPane splitPane;
    String alignment;
    DistanceComputation distanceComputation;
    String[] taxa;
    StringBuffer stringBuffer;
    DecimalFormat decimalFormat;
    DecimalFormatSymbols dfs;
    BirkhaeuserGUIComponents bgc = new BirkhaeuserGUIComponents();
    RunActionListener runActionListener;
    boolean mismatches;

    DistanceComputationGUI() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.runButton = new JButton(Icons.get1rightArrow());
        this.runButton.setToolTipText("Compute Distances");
        this.runActionListener = new RunActionListener();
        this.runButton.addActionListener(this.runActionListener);
        String[] comboItems = new String[]{"Mismatches", "Normalized Mismatches", "Jukes-Cantor"};
        this.comboBox = new JComboBox<String>(comboItems);
        this.resetButton = new JButton(Icons.getUndo());
        this.resetButton.setToolTipText("Reset");
        ResetActionListener resetActionListener = new ResetActionListener();
        this.resetButton.addActionListener(resetActionListener);
        this.toolBar.add(this.runButton);
        this.toolBar.add(this.resetButton);
        this.toolBar.add(this.comboBox);
        this.add((Component)this.toolBar, "North");
        DataContainer dataContainer = new DataContainer();
        this.alignment = dataContainer.getAlignment();
        this.alignmentPane1 = new JTextPane();
        Font font = new Font("Courier", 0, 12);
        this.alignmentPane1.setFont(font);
        this.alignmentPane1.setText(this.alignment);
        this.alignmentPane1.setCaretPosition(0);
        this.alignmentScroll = new JScrollPane(this.alignmentPane1);
        this.distancePane = new JTextPane();
        this.distancePane.setFont(font);
        this.distancePane.setToolTipText("Distance matrix in PHYLIP format");
        this.alignmentPane1.setToolTipText("Alignment in FASTA format");
        this.distancePane.setBackground(this.bgc.getColor1());
        this.alignmentPane1.setBackground(this.bgc.getColor2());
        this.alignmentPane2 = this.alignmentPane1;
        this.alignmentPane2.setCaretPosition(0);
        this.distanceScroll = new JScrollPane(this.distancePane);
        this.splitPane = new JSplitPane(0, this.alignmentScroll, this.distanceScroll);
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)this.splitPane, "Center");
        this.decimalFormat = new DecimalFormat("0.000");
        this.dfs = this.decimalFormat.getDecimalFormatSymbols();
        this.dfs.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(this.dfs);
    }

    private Alignment extractAlignment(String input) {
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer();
        } else {
            this.stringBuffer.delete(0, this.stringBuffer.length());
        }
        String[] units = input.split(">");
        this.taxa = new String[units.length - 1];
        char[][] ac = new char[units.length - 1][];
        int i = 1;
        while (i < this.taxa.length + 1) {
            String[] elements = units[i].split("\n");
            this.taxa[i - 1] = elements[0];
            this.stringBuffer.delete(0, this.stringBuffer.length());
            int j = 1;
            while (j < elements.length) {
                this.stringBuffer.append(elements[j]);
                ++j;
            }
            ac[i - 1] = this.stringBuffer.toString().toCharArray();
            ++i;
        }
        Alignment al = new Alignment(ac, this.taxa);
        return al;
    }

    public Alignment getAlignment() {
        String input = this.alignmentPane1.getText();
        return this.extractAlignment(input);
    }

    public void setAlignment(Alignment al) {
        char[][] ac = al.getAlignment();
        if (this.distanceComputation == null) {
            this.distanceComputation = new DistanceComputation(al.getAlignment());
        } else {
            this.distanceComputation.setAlignment(al.getAlignment());
        }
        String command = (String)this.comboBox.getSelectedItem();
        this.mismatches = false;
        if (command.equals("Jukes-Cantor")) {
            al.setDistanceMatrix(this.distanceComputation.getJukesCantor());
        } else if (command.equals("Normalized Mismatches")) {
            al.setDistanceMatrix(this.distanceComputation.getNormalizedMismatches());
        } else if (command.equals("Mismatches")) {
            this.mismatches = true;
            al.setDistanceMatrix(this.distanceComputation.getMismatches());
        } else {
            System.out.println("ERROR: Combobox commands not synchronized.");
            System.exit(0);
        }
        this.showDistanceMatrix(this.distancePane, al);
    }

    public void runAction() {
        String input = this.alignmentPane2.getText();
        Alignment al = this.extractAlignment(input);
        char[][] ac = al.getAlignment();
        if (this.distanceComputation == null) {
            this.distanceComputation = new DistanceComputation(al.getAlignment());
        } else {
            this.distanceComputation.setAlignment(al.getAlignment());
        }
        String command = (String)this.comboBox.getSelectedItem();
        this.mismatches = false;
        if (command.equals("Jukes-Cantor")) {
            al.setDistanceMatrix(this.distanceComputation.getJukesCantor());
        } else if (command.equals("Normalized Mismatches")) {
            al.setDistanceMatrix(this.distanceComputation.getNormalizedMismatches());
        } else if (command.equals("Mismatches")) {
            this.mismatches = true;
            al.setDistanceMatrix(this.distanceComputation.getMismatches());
        } else {
            System.out.println("ERROR: Combobox commands not synchronized.");
            System.exit(0);
        }
        this.showDistanceMatrix(this.distancePane, al);
    }

    private void showDistanceMatrix(JTextPane distancePane, Alignment al) {
        if (al.getDistanceMatrix() == null) {
            distancePane.setText("ERROR: have you submitted unaligned sequences?");
            return;
        }
        double[][] dm = al.getDistanceMatrix();
        int n = al.getDistanceMatrix().length;
        String[] taxa = al.getTaxa();
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer();
        } else {
            this.stringBuffer.delete(0, this.stringBuffer.length());
        }
        this.stringBuffer.append(n);
        this.stringBuffer.append("\n");
        int i = 0;
        while (i < n) {
            this.stringBuffer.append(String.valueOf(taxa[i]) + "\t");
            int j = 0;
            while (j < n) {
                if (j < i + 1) {
                    this.stringBuffer.append("-\t");
                } else if (this.mismatches) {
                    this.stringBuffer.append(String.valueOf((int)dm[i][j]) + "\t");
                } else {
                    this.stringBuffer.append(String.valueOf(this.decimalFormat.format(dm[i][j])) + "\t");
                }
                ++j;
            }
            this.stringBuffer.append("\n");
            ++i;
        }
        distancePane.setText(this.stringBuffer.toString());
        distancePane.setCaretPosition(0);
    }

    public JScrollPane getAlignmentScroll() {
        return this.alignmentScroll;
    }

    public JScrollPane getDistanceScroll() {
        return this.distanceScroll;
    }

    public JTextPane getAlignmentPane() {
        return this.alignmentPane1;
    }

    public JTextPane getDistancePane() {
        return this.distancePane;
    }

    public RunActionListener getRunActionListener() {
        return this.runActionListener;
    }

    public void setAlignmentPane(JTextPane alignmentPane) {
        this.alignmentPane1 = alignmentPane;
    }

    public JTextPane getAlignmentPane2() {
        return this.alignmentPane2;
    }

    public void setAlignmentPane2(JTextPane alignmentPane2) {
        this.alignmentPane2 = alignmentPane2;
    }

    class RunActionListener
    implements ActionListener {
        RunActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DistanceComputationGUI.this.runAction();
        }
    }

    class ResetActionListener
    implements ActionListener {
        ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DistanceComputationGUI.this.alignmentPane1.setText(DistanceComputationGUI.this.alignment);
            DistanceComputationGUI.this.alignmentPane1.setCaretPosition(0);
            DistanceComputationGUI.this.comboBox.setSelectedIndex(0);
            DistanceComputationGUI.this.distancePane.setText("");
        }
    }
}

