/*
 * Decompiled with CFR 0.152.
 */
package haubold.phylogeny.distance;

import haubold.phylogeny.distance.BootstrapGUI;
import haubold.phylogeny.distance.DistanceComputationGUI;
import haubold.phylogeny.distance.DistanceTreeGUI;
import haubold.resources.demo.DemoFrame;
import haubold.resources.util.OpenSequenceMenuItem;
import haubold.resources.util.PrintMenuItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.print.Printable;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DistanceTreeDemo
extends DemoFrame {
    JTabbedPane tp;
    DistanceComputationGUI dcg;
    DistanceTreeGUI dtg;
    BootstrapGUI bg;
    PrintMenuItem pmi;
    OpenSequenceMenuItem osmi;
    DemoFrame frame = this;

    public DistanceTreeDemo(String titleString, String helpPath) {
        this.setTitle(titleString);
        this.setHelpPath(helpPath);
        this.getContentPane().setLayout(new BorderLayout());
        this.tp = new JTabbedPane();
        this.getContentPane().add((Component)this.tp, "Center");
        this.dcg = new DistanceComputationGUI();
        this.dtg = new DistanceTreeGUI();
        this.bg = new BootstrapGUI();
        this.tp.addTab("Distance Matrix", this.dcg);
        this.tp.addTab("Phylogeny", this.dtg);
        this.tp.addTab("Bootstrap", this.bg);
        TabChangeListener tcl = new TabChangeListener();
        this.tp.addChangeListener(tcl);
        this.osmi = new OpenSequenceMenuItem("Open Sequence Alignment", 79, this.dcg.getAlignmentPane());
        this.osmi.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.getFileMenu().add((Component)this.osmi, 0);
        this.pmi = this.getFileMenu().getPrintMenuItem();
        this.pmi.setPrintable(this.dcg);
    }

    class TabChangeListener
    implements ChangeListener {
        String text;

        TabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            DistanceTreeDemo.this.dtg.setDistanceText(DistanceTreeDemo.this.dcg.getDistancePane().getText());
            this.text = DistanceTreeDemo.this.dcg.getAlignmentPane().getText();
            DistanceTreeDemo.this.bg.getDistanceComputationGUI().getAlignmentPane().setText(this.text);
            DistanceTreeDemo.this.bg.getDistanceComputationGUI().getAlignmentPane().setCaretPosition(0);
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            Printable printable = (Printable)((Object)tabPane.getSelectedComponent());
            DistanceTreeDemo.this.pmi.setPrintable(printable);
            Component object = tabPane.getSelectedComponent();
            if (object.getClass() == DistanceTreeDemo.this.dtg.getClass()) {
                DistanceTreeDemo.this.osmi.setEnabled(false);
            } else if (object.getClass() == DistanceTreeDemo.this.bg.getClass()) {
                DistanceTreeDemo.this.osmi.setEnabled(true);
                DistanceTreeDemo.this.osmi.setTextPane(DistanceTreeDemo.this.bg.getDistanceComputationGUI().getAlignmentPane());
            } else if (object.getClass() == DistanceTreeDemo.this.dcg.getClass()) {
                DistanceTreeDemo.this.osmi.setEnabled(true);
                DistanceTreeDemo.this.osmi.setTextPane(DistanceTreeDemo.this.dcg.getAlignmentPane());
            }
        }
    }
}

