/*
 * Decompiled with CFR 0.152.
 */
package haubold.resources.graphics;

import haubold.resources.graphics.Gene;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.swing.JPanel;

public class Drawing
extends JPanel {
    ArrayList geneList = new ArrayList();
    Gene gene;
    MouseListener[] ml;

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.geneList.size()) {
            this.gene = (Gene)this.geneList.get(i);
            this.gene.paint(g);
            ++i;
        }
    }

    public Drawing() {
        GeneListener geneListener = new GeneListener();
    }

    public void addGene(Gene g) {
        g.setDrawing(this);
        GeneListener geneListener = new GeneListener();
        g.addMouseListener(geneListener);
        this.geneList.add(g);
        this.repaint();
    }

    public void removeGene(Gene g) {
        this.geneList.remove(g);
        this.repaint();
    }

    public void removeAllGenes() {
        int i = 0;
        while (i < this.geneList.size()) {
            Gene g = (Gene)this.geneList.get(i);
            this.geneList.remove(i);
            ++i;
        }
        this.repaint();
    }

    class GeneListener
    implements MouseListener {
        Rectangle hitRect = new Rectangle(0, 0, 3, 3);

        GeneListener() {
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            System.out.println("Mouse pressed");
            if (this.geneHit(evt)) {
                Gene gene = (Gene)evt.getSource();
                Graphics2D g = (Graphics2D)gene.getGraphics();
                Rectangle geneRect = gene.getGeneRect();
                AffineTransform transform = g.getTransform();
                g.setColor(Color.green);
                g.fill(geneRect);
                g.setTransform(transform);
            }
        }

        public void mouseClicked(MouseEvent evt) {
            System.out.println("Mouse clicked");
        }

        private boolean geneHit(MouseEvent evt) {
            Rectangle geneRect;
            this.hitRect.x = evt.getX() - 1;
            this.hitRect.y = evt.getY() - 1;
            Gene gene = (Gene)evt.getSource();
            Graphics2D g = (Graphics2D)gene.getGraphics();
            return g.hit(this.hitRect, geneRect = gene.getGeneRect(), false);
        }
    }
}

