/*
 * Decompiled with CFR 0.152.
 */
package haubold.resources.util;

import haubold.resources.util.BirkhaeuserAboutButton;
import haubold.resources.util.BirkhaeuserAboutMenuItem;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BirkhaeuserGUIComponents {
    private Color color1;
    private Color lightGreen;
    private Color color2;
    private Color lightYellow;
    private Color color3;
    private Color darkRed;
    private Color color4;
    private Color lightBlue;
    private Color color5;
    private Color darkGreen;
    private JSlider slider;
    private String sliderTitle = "Slider Title";
    private JButton aboutButton;
    private Border sliderBorder;
    private String version;

    public BirkhaeuserGUIComponents() {
    }

    public BirkhaeuserGUIComponents(String version) {
        this.version = version;
    }

    public Color getColor1() {
        if (this.lightGreen == null) {
            this.lightGreen = new Color(220, 255, 220);
        }
        this.color1 = this.lightGreen;
        return this.color1;
    }

    public Color getColor2() {
        if (this.lightYellow == null) {
            this.color2 = this.lightYellow = new Color(255, 255, 204);
        }
        return this.color2;
    }

    public JSlider getSlider(int minimumValue, int maximumValue, int initialValue, String sliderTitle) {
        this.sliderTitle = sliderTitle;
        this.slider = new JSlider(minimumValue, maximumValue, initialValue);
        this.slider.setMajorTickSpacing((maximumValue - minimumValue) / 5);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(false);
        this.sliderBorder = new TitledBorder(sliderTitle);
        this.slider.setBorder(this.sliderBorder);
        return this.slider;
    }

    public String getSliderTitle() {
        return this.sliderTitle;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public void setSliderTitle(String sliderTitle) {
        this.sliderBorder = new TitledBorder(sliderTitle);
        this.slider.setBorder(this.sliderBorder);
        this.sliderTitle = sliderTitle;
    }

    public JButton getAboutButton(String title) {
        BirkhaeuserAboutButton aboutButton = new BirkhaeuserAboutButton();
        aboutButton.setTitleString(title);
        return aboutButton;
    }

    public JMenuItem getAboutMenuItem(String title) {
        BirkhaeuserAboutMenuItem aboutMenuItem = new BirkhaeuserAboutMenuItem(this.version);
        aboutMenuItem.setTitleString(title);
        return aboutMenuItem;
    }

    public Color getColor3() {
        if (this.darkRed == null) {
            this.color3 = this.darkRed = new Color(204, 102, 0);
        }
        return this.color3;
    }

    public Color getColor4() {
        if (this.lightBlue == null) {
            this.color4 = this.lightBlue = new Color(204, 204, 255);
        }
        return this.color4;
    }

    public Color getColor5() {
        if (this.darkGreen == null) {
            this.color5 = this.darkGreen = new Color(51, 153, 0);
        }
        return this.color5;
    }

    public String getVersion() {
        return this.version;
    }
}

