/*
 * Decompiled with CFR 0.152.
 */
package haubold.sm;

import haubold.resources.util.BirkhaeuserGUIComponents;
import haubold.resources.util.PrintableJPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

public class MatrixDisplayPanel
extends PrintableJPanel {
    int[][] values;
    int percentDifference;
    String[] aminoAcids;
    BirkhaeuserGUIComponents bgc;
    Color backgroundColor;

    public MatrixDisplayPanel(int[][] values, String[] aminoAcids, int percentDifference) {
        this.values = values;
        this.aminoAcids = aminoAcids;
        this.percentDifference = percentDifference;
        this.bgc = new BirkhaeuserGUIComponents();
        this.backgroundColor = this.bgc.getColor1();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int stepX = 40;
        int stepY = 20;
        int rx1 = 0;
        int ry1 = 0;
        int rx2 = 21 * stepX - stepX / 2;
        int ry2 = 22 * stepY - stepY / 2;
        String str = new String();
        Font courier = new Font("courier", 1, 18);
        Font times = new Font("times", 0, 18);
        g2.setFont(courier);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dim = this.getSize();
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        g2.setColor(this.backgroundColor);
        g2.fillRect(0, 0, w, h);
        AffineTransform transform = g2.getTransform();
        double scaleX = (double)this.getWidth() / 23.0 / (double)stepX;
        double scaleY = (double)this.getHeight() / 24.0 / (double)stepY;
        double scale = Math.min(scaleX, scaleY);
        int tx = (int)(((double)this.getWidth() - (double)(rx2 - rx1) * scale) / 2.0);
        int ty = this.percentDifference > 0 ? (int)(((double)this.getHeight() - (double)(ry2 - ry1 + stepY) * scale) / 2.0) : (int)(((double)this.getHeight() - (double)(ry2 - ry1) * scale) / 2.0);
        g2.translate(tx, ty);
        g2.scale(scale, scale);
        g2.setColor(Color.black);
        g2.drawRoundRect(rx1, ry1, rx2, ry2, 30, 30);
        g2.setColor(Color.red);
        int i = 0;
        while (i < 20) {
            g2.drawString(this.aminoAcids[i], (i + 1) * stepX - 2, stepY);
            g2.drawString(this.aminoAcids[i], 4, (i + 2) * stepY);
            ++i;
        }
        i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                if (i == j) {
                    g2.setColor(Color.blue);
                } else {
                    g2.setColor(Color.black);
                }
                str = String.valueOf(this.values[j][i]);
                int strLen = str.length();
                g2.drawString(str, i * stepX + (stepX + 3 - strLen * 7), (j + 2) * stepY);
                ++j;
            }
            ++i;
        }
        g2.setFont(times);
        if ((double)this.percentDifference > 0.0) {
            g2.drawString(" Expected difference = " + String.valueOf(this.percentDifference) + "%", 8 * stepX, 23 * stepY);
        }
        g2.setTransform(transform);
    }

    public String[] getAminoAcids() {
        return this.aminoAcids;
    }

    public int getPercentDifference() {
        return this.percentDifference;
    }

    public int[][] getValues() {
        return this.values;
    }

    public void setAminoAcids(String[] strings) {
        this.aminoAcids = strings;
    }

    public void setPercentDifference(int i) {
        this.percentDifference = i;
    }

    public void setValues(int[][] is) {
        this.values = is;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }
}

