/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import haubold.stringmatching.suffixtree.algorithms.SuffixNode;

public class TreeMonitor {
    public void writeTree(SuffixNode tree) {
        this.traverseTree(tree);
    }

    private void traverseTree(SuffixNode node) {
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.traverseTree(children[i]);
                ++i;
            }
        }
        this.debugOutput(node);
    }

    private void debugOutput(SuffixNode node) {
        String output = "Id: " + node.getId() + " start " + node.getStartLabel() + " end " + node.getEndLabel();
        output = node.getParent() != null ? String.valueOf(output) + " parentId: " + node.getParent().getId() : String.valueOf(output) + " node is ROOT ";
        if (node.isLeaf()) {
            output = String.valueOf(output) + " leaf-label: " + node.getLeafLabel() + " stringId: " + node.getStringId();
        }
        System.out.println(output);
    }
}

