/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.algorithms;

import haubold.stringmatching.suffixtree.algorithms.ReferencePair;
import haubold.stringmatching.suffixtree.algorithms.Repeat;
import haubold.stringmatching.suffixtree.algorithms.SourceNode;
import haubold.stringmatching.suffixtree.algorithms.SuffixNode;
import haubold.stringmatching.suffixtree.algorithms.SuffixTree;
import haubold.stringmatching.suffixtree.algorithms.TreeMonitor;
import java.util.ArrayList;

public class UkkonenSuffixTree
implements SuffixTree {
    private char[] text1;
    private char[] text2;
    SuffixNode root;
    boolean debug;
    TreeMonitor monitor;
    int leafEnd;
    int leafLabel;
    int longestRepeatLength;
    ArrayList matchList;
    boolean masked = false;
    ReferencePair referencePair;
    private int stringCount = 1;

    public void constructSuffixTree(char[] text) {
        this.text1 = text;
        this.text2 = text;
        SourceNode source = new SourceNode();
        this.root = new SuffixNode(null, -1, -1);
        source.setStartLabel(0);
        source.setEndLabel(1);
        source.setRoot(this.root);
        this.root.setSuffixLink(source);
        this.referencePair = new ReferencePair();
        this.referencePair.setNode(this.root);
        this.referencePair.setLeftPointer(0);
        int i = -1;
        this.leafLabel = -1;
        while (i < text.length - 1) {
            this.leafEnd = ++i;
            this.referencePair.setRightPointer(i);
            this.referencePair = this.update(this.referencePair);
            this.referencePair.setRightPointer(i);
            this.referencePair = this.canonize(this.referencePair);
        }
        this.fixLeafEndLabels(this.root);
        if (this.debug) {
            this.monitor.writeTree(this.root);
        }
    }

    private ReferencePair update(ReferencePair referencePair) {
        SuffixNode s = referencePair.getNode();
        int k = referencePair.getLeftPointer();
        int i = referencePair.getRightPointer();
        SuffixNode oldR = this.root;
        referencePair.setRightPointer(i - 1);
        referencePair = this.testAndSplit(referencePair, this.text2[i]);
        SuffixNode r = referencePair.getNode();
        while (!referencePair.isEndPoint()) {
            SuffixNode rDash = new SuffixNode(r, i, Integer.MAX_VALUE);
            r.addChild(this.text2[i], rDash);
            rDash.setLeafLabel(++this.leafLabel);
            rDash.setStringId(this.stringCount);
            if (oldR.getParent() != null) {
                oldR.setSuffixLink(r);
            }
            oldR = r;
            SuffixNode sl = s.getSuffixLink();
            referencePair.setNode(sl);
            referencePair = this.canonize(referencePair);
            s = referencePair.getNode();
            referencePair = this.testAndSplit(referencePair, this.text2[i]);
            r = referencePair.getNode();
        }
        if (oldR.getParent() != null) {
            oldR.setSuffixLink(s);
        }
        referencePair.setNode(s);
        return referencePair;
    }

    private ReferencePair testAndSplit(ReferencePair referencePair, char t) {
        int p;
        SuffixNode s = referencePair.getNode();
        int k = referencePair.getLeftPointer();
        if (k <= (p = referencePair.getRightPointer())) {
            SuffixNode sDash = s.getChild(this.text2[k]);
            if (t == this.text1[sDash.getStartLabel() + p - k + 1]) {
                referencePair.setEndPoint(true);
                return referencePair;
            }
            SuffixNode r = new SuffixNode(s, sDash.getStartLabel(), sDash.getStartLabel() + p - k);
            s.removeChild(this.text2[k]);
            s.addChild(this.text2[r.getStartLabel()], r);
            sDash.setParent(r);
            sDash.setStartLabel(sDash.getStartLabel() + p - k + 1);
            r.addChild(this.text1[sDash.getStartLabel()], sDash);
            referencePair.setNode(r);
            referencePair.setEndPoint(false);
            if (this.isMasked()) {
                if (r.getParent().isMasked()) {
                    r.setNodeDepth(0);
                } else {
                    int i = r.getStartLabel();
                    while (i <= r.getEndLabel()) {
                        if (this.text1[i] == 'x' || this.text1[i] == 'X' || this.text1[i] == 'n' || this.text1[i] == 'N') {
                            r.setNodeDepth(0);
                            r.setMasked(true);
                            break;
                        }
                        ++i;
                    }
                    if (r.isMasked()) {
                        r.setNodeDepth(0);
                    } else {
                        r.setNodeDepth(r.getParent().getNodeDepth() + r.getEndLabel() - r.getStartLabel() + 1);
                    }
                }
            } else {
                r.setNodeDepth(r.getParent().getNodeDepth() + r.getEndLabel() - r.getStartLabel() + 1);
            }
            return referencePair;
        }
        if (s.getChild(t) == null) {
            referencePair.setEndPoint(false);
            return referencePair;
        }
        referencePair.setEndPoint(true);
        return referencePair;
    }

    private ReferencePair canonize(ReferencePair referencePair) {
        SuffixNode s = referencePair.getNode();
        int k = referencePair.getLeftPointer();
        int p = referencePair.getRightPointer();
        if (p < k) {
            return referencePair;
        }
        SuffixNode testNode = s.getChild(this.text2[k]);
        while (testNode.getEndLabel() - testNode.getStartLabel() <= p - k) {
            s = testNode;
            if ((k += s.getEndLabel() - s.getStartLabel() + 1) > p) continue;
            testNode = s.getChild(this.text2[k]);
        }
        referencePair.setNode(s);
        referencePair.setLeftPointer(k);
        return referencePair;
    }

    private ReferencePair findReferencePair(char[] pattern) {
        int pi = 0;
        SuffixNode node = this.root;
        if (node.getChild(pattern[0]) == null) {
            return null;
        }
        node = node.getChild(pattern[0]);
        int i = 0;
        while (pi < pattern.length && this.text1[node.getStartLabel() + i] == pattern[pi]) {
            ++pi;
            if (node.getStartLabel() + ++i <= node.getEndLabel()) continue;
            if (pi >= pattern.length || node.getChild(pattern[pi]) == null) break;
            node = node.getChild(pattern[pi]);
            i = 0;
        }
        this.referencePair.setNode(node.getParent());
        this.referencePair.setLeftPointer(pi - 1);
        return this.referencePair;
    }

    public ArrayList match(char[] pattern) {
        SuffixNode node;
        int pi = 0;
        if (this.matchList == null) {
            this.matchList = new ArrayList();
        }
        if ((node = this.root).getChild(pattern[0]) == null) {
            this.matchList.clear();
            return this.matchList;
        }
        node = node.getChild(pattern[0]);
        int i = 0;
        while (pi < pattern.length && this.text1[node.getStartLabel() + i] == pattern[pi]) {
            ++pi;
            if (node.getStartLabel() + ++i <= node.getEndLabel()) continue;
            if (pi >= pattern.length || node.getChild(pattern[pi]) == null) break;
            node = node.getChild(pattern[pi]);
            i = 0;
        }
        --i;
        this.matchList.clear();
        if (--pi == pattern.length - 1) {
            this.searchLeaves(node);
        }
        return this.matchList;
    }

    public ArrayList findRepeat(int length) {
        ArrayList repeatList = new ArrayList();
        repeatList = this.findRepeat(this.root, length, repeatList);
        return repeatList;
    }

    private ArrayList findRepeat(SuffixNode node, int length, ArrayList repeatList) {
        if (!node.isLeaf()) {
            if (node.getNodeDepth() == length) {
                Repeat repeat = new Repeat(length, node);
                repeatList.add(this.findRepeatPositions(node, repeat, length));
            }
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.findRepeat(children[i], length, repeatList);
                ++i;
            }
        }
        return repeatList;
    }

    private Repeat findRepeatPositions(SuffixNode node, Repeat repeat, int length) {
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.findRepeatPositions(children[i], repeat, length);
                ++i;
            }
        } else {
            repeat.add(new Integer(node.getLeafLabel()));
        }
        return repeat;
    }

    private void searchLeaves(SuffixNode node) {
        if (!node.isLeaf()) {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.searchLeaves(children[i]);
                ++i;
            }
        } else {
            this.matchList.add(new Integer(node.getLeafLabel()));
        }
    }

    private void fixLeafEndLabels(SuffixNode node) {
        if (node.isLeaf()) {
            node.setEndLabel(this.leafEnd);
        } else {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.fixLeafEndLabels(children[i]);
                ++i;
            }
        }
    }

    private Repeat findLongestRepeat(SuffixNode node, Repeat longestRepeat) {
        if (!node.isLeaf()) {
            if (node.getNodeDepth() > longestRepeat.getLength()) {
                longestRepeat.setLength(node.getNodeDepth());
                longestRepeat.setNode(node);
            }
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.findLongestRepeat(children[i], longestRepeat);
                ++i;
            }
        }
        return longestRepeat;
    }

    private Repeat findLongestRepeatPositions(SuffixNode node, Repeat repeat) {
        if (node.isLeaf()) {
            repeat.add(new Integer(node.getLeafLabel()));
        } else {
            SuffixNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                this.findLongestRepeatPositions(children[i], repeat);
                ++i;
            }
        }
        return repeat;
    }

    public SuffixNode getRoot() {
        return this.root;
    }

    public char[] getText() {
        return this.text1;
    }

    public void setRoot(SuffixNode root) {
        this.root = root;
    }

    public void setText(char[] text) {
        this.text1 = text;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (debug && this.monitor == null) {
            this.monitor = new TreeMonitor();
        }
    }

    public ArrayList getLongestRepeat() {
        Repeat longestRepeat = new Repeat();
        ArrayList repeatList = new ArrayList();
        longestRepeat.setLength(0);
        longestRepeat.clear();
        longestRepeat = this.findLongestRepeat(this.root, longestRepeat);
        repeatList = this.findRepeat(longestRepeat.getLength());
        return repeatList;
    }

    public int getLongestRepeatLength() {
        Repeat longestRepeat = new Repeat();
        ArrayList repeatList = new ArrayList();
        longestRepeat.setLength(0);
        longestRepeat.clear();
        longestRepeat = this.findLongestRepeat(this.root, longestRepeat);
        return longestRepeat.getLength();
    }

    public boolean isMasked() {
        return this.masked;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }
}

