/*
 * Decompiled with CFR 0.152.
 */
package haubold.stringmatching.suffixtree.gui;

import haubold.resources.util.DataContainer;
import haubold.stringmatching.suffixtree.algorithms.DrawSTLatex;
import haubold.stringmatching.suffixtree.algorithms.UkkonenSuffixTree;
import java.util.ArrayList;

public class TestSuffixTree {
    TestSuffixTree() {
    }

    public static void main(String[] arg) {
        DataContainer data = new DataContainer();
        UkkonenSuffixTree st = new UkkonenSuffixTree();
        DrawSTLatex latex = new DrawSTLatex();
        st.setDebug(false);
        ArrayList<Integer> list = new ArrayList<Integer>();
        String text = "ACCGCTCA$";
        String pattern = "GTTCGT";
        char[] textChar = text.toCharArray();
        char[] patternChar = pattern.toCharArray();
        long t1 = System.currentTimeMillis();
        st.constructSuffixTree(textChar);
        latex.draw(st, "/home/haubold/Publications/IntroBioinf/Text/ExactMatching/Figures/accgctca.tex");
        long t2 = System.currentTimeMillis();
        System.out.println("Suffix tree constructed in " + (t2 - t1) + " ms.");
        t1 = System.currentTimeMillis();
        ArrayList matchList = st.match(patternChar);
        t2 = System.currentTimeMillis();
        System.out.println("Matching in suffix tree: " + (t2 - t1) + " ms");
        int i = 0;
        while (i < matchList.size()) {
            System.out.println("match at: " + matchList.get(i));
            ++i;
        }
        t1 = System.currentTimeMillis();
        i = 0;
        while (i < text.length() - patternChar.length + 1) {
            int j = 0;
            while (j < patternChar.length && textChar[i + j] == patternChar[j]) {
                ++j;
            }
            if (j == pattern.length()) {
                list.add(new Integer(i));
            }
            ++i;
        }
        t2 = System.currentTimeMillis();
        System.out.println("Matching with naive algorithm: " + (t2 - t1) + " ms");
        System.out.println("CLASSICAL RESULTS:");
        i = 0;
        while (i < list.size()) {
            System.out.println("Classical match at: " + list.get(i));
            ++i;
        }
    }
}

