/*
 * Decompiled with CFR 0.152.
 */
package haubold.wrightfisher;

import haubold.wrightfisher.SwingShapeMover;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class DPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    Rectangle rect = new Rectangle(0, 0, 100, 50);
    BufferedImage bi;
    Graphics2D big;
    int last_x;
    int last_y;
    boolean firstTime = true;
    TexturePaint fillPolka;
    TexturePaint strokePolka;
    Rectangle area;
    boolean pressOut = false;

    public DPanel() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.bi = new BufferedImage(5, 5, 1);
        this.big = this.bi.createGraphics();
        this.big.setColor(Color.pink);
        this.big.fillRect(0, 0, 7, 7);
        this.big.setColor(Color.cyan);
        this.big.fillOval(0, 0, 3, 3);
        Rectangle r = new Rectangle(0, 0, 5, 5);
        this.fillPolka = new TexturePaint(this.bi, r);
        this.big.dispose();
        this.bi = new BufferedImage(5, 5, 1);
        this.big = this.bi.createGraphics();
        this.big.setColor(Color.cyan);
        this.big.fillRect(0, 0, 7, 7);
        this.big.setColor(Color.pink);
        this.big.fillOval(0, 0, 3, 3);
        r = new Rectangle(0, 0, 5, 5);
        this.strokePolka = new TexturePaint(this.bi, r);
        this.big.dispose();
    }

    public void mousePressed(MouseEvent e) {
        this.last_x = this.rect.x - e.getX();
        this.last_y = this.rect.y - e.getY();
        if (this.rect.contains(e.getX(), e.getY())) {
            this.updateLocation(e);
        } else {
            SwingShapeMover.label.setText("First position the cursor on the rectangle and then drag.");
            this.pressOut = true;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.pressOut) {
            this.updateLocation(e);
        } else {
            SwingShapeMover.label.setText("First position the cursor on the rectangle and then drag.");
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.rect.contains(e.getX(), e.getY())) {
            this.updateLocation(e);
        } else {
            SwingShapeMover.label.setText("First position the cursor on the rectangle and then drag.");
            this.pressOut = false;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void updateLocation(MouseEvent e) {
        this.rect.setLocation(this.last_x + e.getX(), this.last_y + e.getY());
        if (this.checkRect()) {
            SwingShapeMover.label.setText("Rectangle located at " + this.rect.getX() + ", " + this.rect.getY());
        } else {
            SwingShapeMover.label.setText("Please don't try to  drag outside the area.");
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(8.0f));
        Dimension dim = this.getSize();
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        if (this.firstTime) {
            this.area = new Rectangle(dim);
            this.rect.setLocation(w / 2 - 50, h / 2 - 25);
            this.firstTime = false;
        }
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, w, h);
        g2.setPaint(this.fillPolka);
        g2.fill(this.rect);
        g2.setPaint(this.strokePolka);
        g2.draw(this.rect);
    }

    boolean checkRect() {
        if (this.area == null) {
            return false;
        }
        if (this.area.contains(this.rect.x, this.rect.y, 100, 50)) {
            return true;
        }
        int new_x = this.rect.x;
        int new_y = this.rect.y;
        if ((double)(this.rect.x + 100) > this.area.getWidth()) {
            new_x = (int)this.area.getWidth() - 99;
        }
        if (this.rect.x < 0) {
            new_x = -1;
        }
        if ((double)(this.rect.y + 50) > this.area.getHeight()) {
            new_y = (int)this.area.getHeight() - 49;
        }
        if (this.rect.y < 0) {
            new_y = -1;
        }
        this.rect.setLocation(new_x, new_y);
        return false;
    }
}

