/*
 * Decompiled with CFR 0.152.
 */
package haubold.wrightfisher;

import haubold.wrightfisher.Node;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Random;

public class WrightFisher {
    private Random ran = new Random();
    private Node[][] pop;
    private int[] posTable;
    boolean mrca;

    public Node[][] constructPopulation(int numGen, int popSize) {
        int j;
        this.posTable = new int[numGen];
        this.pop = new Node[numGen][popSize];
        int i = 0;
        while (i < numGen) {
            j = 0;
            while (j < popSize) {
                this.pop[i][j] = new Node();
                this.pop[i][j].setId(j + 1);
                this.pop[i][j].setGeneration(i);
                this.pop[i][j].setTangledX(j);
                this.pop[i][j].setShape(new Ellipse2D.Double((j + 4) * 10 - 2, (i + 1) * 12 - 2, 4.0, 4.0));
                this.pop[i][j].setColorForward(Color.black);
                this.pop[i][j].setColorBackward(Color.black);
                ++j;
            }
            ++i;
        }
        int m = numGen - 1;
        i = 0;
        while (i < popSize) {
            this.pop[m][i].getDescendants().add(this.pop[numGen - 1][i]);
            ++i;
        }
        i = numGen - 1;
        while (i > 0) {
            j = 0;
            while (j < popSize) {
                int r = this.ran.nextInt(popSize);
                this.pop[i][j].setAncestor1(this.pop[i - 1][r]);
                this.pop[i - 1][r].getChildren().add(this.pop[i][j]);
                this.pop[i - 1][r].getOffspring().add(this.pop[i][j]);
                this.uniteDescendants(this.pop[i][j], this.pop[i - 1][r]);
                r = this.ran.nextInt(popSize);
                this.pop[i][j].setAncestor2(this.pop[i - 1][r]);
                this.pop[i - 1][r].getChildren().add(this.pop[i][j]);
                this.uniteDescendants(this.pop[i][j], this.pop[i - 1][r]);
                ++j;
            }
            --i;
        }
        this.untangle();
        return this.pop;
    }

    private void untangle() {
        int numGen = this.pop.length;
        int popSize = this.pop[0].length;
        int i = 0;
        while (i < numGen) {
            int j = 0;
            while (j < popSize) {
                if (!this.pop[i][j].isVisited()) {
                    this.traverseSubgraph(this.pop[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void traverseSubgraph(Node node) {
        if (node != null) {
            node.setUntangledShape(new Ellipse2D.Double((this.posTable[node.getGeneration()] + 4) * 10 - 2, (node.getGeneration() + 1) * 12 - 2, 4.0, 4.0));
            int n = node.getGeneration();
            this.posTable[n] = this.posTable[n] + 1;
            node.setVisited(true);
            ArrayList offspring = node.getOffspring();
            int i = 0;
            while (i < offspring.size()) {
                this.traverseSubgraph((Node)offspring.get(i));
                ++i;
            }
        }
    }

    private void uniteDescendants(Node child, Node parent) {
        int i = 0;
        while (i < child.getDescendants().size()) {
            if (!parent.getDescendants().contains(child.getDescendants().get(i))) {
                parent.getDescendants().add(child.getDescendants().get(i));
            }
            ++i;
        }
    }

    public boolean isMrca() {
        return this.mrca;
    }

    public void setMrca(boolean mrca) {
        this.mrca = mrca;
    }
}

