/*
 * Decompiled with CFR 0.152.
 */
package haubold.maths;

import haubold.maths.Algebra;
import java.util.Iterator;
import java.util.TreeSet;

public class KarlinAltschul {
    TreeSet scoreSet = new TreeSet();

    public double K(double[] p, double[][] s, double lambda) {
        int j;
        double K = 0.0;
        double tol = 1.0E-10;
        double S1 = 0.0;
        double Sn = 0.0;
        double Pp = 0.0;
        int neg = 0;
        int i = 0;
        while (i < p.length) {
            j = 0;
            while (j < p.length) {
                S1 += p[i] * p[j] * s[i][j];
                if (s[i][j] < 0.0) {
                    ++neg;
                    Sn += p[i] * p[j] * Math.exp(lambda * s[i][j]);
                } else {
                    Pp += p[i] * p[j];
                }
                ++j;
            }
            ++i;
        }
        double n = 0.0;
        int k = 1;
        n += 1.0 / (double)k * ((double)k / (double)neg * (Sn *= (double)p.length * (double)p.length / (double)neg) + Math.pow(Pp, k));
        double o = 0.0;
        System.out.println("Lambda: " + lambda + " ln(3):" + Math.log(3.0));
        System.out.println("Sn:" + Sn);
        while (n - o > tol) {
            o = n;
            n += 1.0 / (double)(++k) * ((double)neg / (double)k * Sn + Math.pow(Pp, k));
        }
        System.out.println("k: " + k + " n: " + n);
        System.out.println("S1: " + S1);
        double C = Math.exp(-2.0 * n) / (lambda * S1 * Math.exp(lambda * S1));
        this.scoreSet.clear();
        i = 0;
        while (i < p.length) {
            j = 0;
            while (j <= i) {
                this.scoreSet.add(new Integer((int)s[i][j]));
                ++j;
            }
            ++i;
        }
        k = (Integer)this.scoreSet.first();
        Iterator it = this.scoreSet.iterator();
        it.next();
        int delta = 2;
        while (it.hasNext() && delta > 1) {
            delta = Algebra.gcd((Integer)it.next(), k);
        }
        K = C * lambda * (double)delta / (1.0 - Math.exp(-lambda * (double)delta));
        return K;
    }

    public double lambda(double[] p, double[][] s) {
        int j;
        double sum = 0.0;
        double hi = 1.0;
        double lo = 0.0;
        double tol = Math.pow(10.0, -10.0);
        double lambda = 1.0;
        sum = 0.0;
        int i = 0;
        while (i < p.length) {
            j = 0;
            while (j < p.length) {
                sum += p[i] * p[j] * Math.exp(lambda * s[i][j]);
                ++j;
            }
            ++i;
        }
        while (sum > 1.0) {
            lambda -= 0.5;
            sum = 0.0;
            i = 0;
            while (i < p.length) {
                j = 0;
                while (j < p.length) {
                    sum += p[i] * p[j] * Math.exp(lambda * s[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        lo = lambda;
        lambda = 1.0;
        sum = 0.0;
        i = 0;
        while (i < p.length) {
            j = 0;
            while (j < p.length) {
                sum += p[i] * p[j] * Math.exp(lambda * s[i][j]);
                ++j;
            }
            ++i;
        }
        while (sum < 1.0) {
            lambda += 0.5;
            sum = 0.0;
            i = 0;
            while (i < p.length) {
                j = 0;
                while (j < p.length) {
                    sum += p[i] * p[j] * Math.exp(lambda * s[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        hi = lambda;
        lambda = (hi + lo) / 2.0;
        while (hi - lo > tol) {
            sum = 0.0;
            i = 0;
            while (i < p.length) {
                j = 0;
                while (j < p.length) {
                    sum += p[i] * p[j] * Math.exp(lambda * s[i][j]);
                    ++j;
                }
                ++i;
            }
            if (sum > 1.0) {
                hi = lambda;
            } else {
                lo = lambda;
            }
            lambda = (hi + lo) / 2.0;
        }
        return lambda;
    }

    public double id(double[] p, double[][] s, double lambda) {
        double sum = 0.0;
        int i = 0;
        while (i < p.length) {
            sum += p[i] * p[i] * Math.exp(lambda * s[i][i]);
            ++i;
        }
        return sum;
    }

    public double h(double[] p, double[][] s, double lambda) {
        double sum = 0.0;
        int i = 0;
        while (i < p.length) {
            int j = 0;
            while (j < p.length) {
                sum += p[i] * p[j] * Math.exp(lambda * s[i][j]) * lambda * s[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }
}

