(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4424,        111]*)
(*NotebookOutlinePosition[      5068,        133]*)
(*  CellTagsIndexPosition[      5024,        129]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{
        Cell["G14TINFOC  Focal length"], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", Cell["\<\
1. Calculation of focal length of thin lens of refractive index n2 in medium \
with refractive index n1.\
\>"], "\[IndentingNewLine]", Cell["\<\
First Surface
r1 = -5

Second surface
r2 = 5\
\>"], Cell["\<\
r is positive for convex surface, negative for concave surface
refractive index of lens n2     n2 = 1
refractive index of medium n1   n1 = 1.5
f = n1/((n2-n1)/r1 + (n1-n2)/r2)
f = 7.5\
\>"], "\[IndentingNewLine]", Cell["\<\
2. Graph of focal length of thin lens with index n2 depending on refractive \
index of medium n1

The range of n1 is divided into lower and higher range because of \
singularity.\
\>"]}], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(r1\  = \ \(-5\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(r2\  = \ 5;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Refractive\ index\ of\ lens\ nn2\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(nn2\  = \ 1.5;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Lower\ range\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(nn1\  = \ Range[1, nn2 - 0.00001, 0.1];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Upper\ range\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(nnn1\  = \ Range[nn2\  + \ 0.1, 4, 0.1];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ff[nn1_] := \ 
        1/\((\((nn2 - nn1)\)/r1 + \((nn1 - nn2)\)/
                r2)\);\), "\[IndentingNewLine]", 
    RowBox[{\(fff[nnn1_] := 
          1/\((\((nn2 - nnn1)\)/r1 + \((nnn1 - nn2)\)/r2)\);\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{nn1, ff[nn1]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<nn1\>", "\<ff[nn1]\>"}, 
            PlotRange \[Rule] {{1, 1.4}, {\(-30\), 0}}], {{{Hue[
                  1], "\<ff[nn1]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{nnn1, fff[nnn1]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<nnn1\>", "\<fff[nnn1]\>"}, 
          PlotRange \[Rule] {{1, 4}, {0, 30}}], {{{Hue[1], "\<fff[nnn1]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{1016, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2715, 59, 781, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

