(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3761,         91]*)
(*NotebookOutlinePosition[      4441,        114]*)
(*  CellTagsIndexPosition[      4397,        110]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{\(<< Graphics`Graphics3D`\), "\[IndentingNewLine]", 
    RowBox[{Cell[""], 
      RowBox[{"(*", " ", "\[IndentingNewLine]", 
        RowBox[{
          StyleBox["G2FERMAT",
            "Outline1"], 
          StyleBox["   ",
            "Outline1"], 
          StyleBox["\[IndentingNewLine]",
            "Outline1"], "\[IndentingNewLine]", Cell["FERMAT's PRINCIPLE"], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", Cell["\<\
t is the time to go from the initial position (0,0) to point (xq,q) with \
velocity v1
tt is the tiime to go from point (xq,q) to point (xp,p) with velocity v2
ttt is the time to go from point (xp,p) to the final position (xf,yf) with \
velocity v3
There is a q and p value for minimum time
\
\>"]}], "      ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(n\  = \ 20;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(xq\  = \ 
        20;\), "\[IndentingNewLine]", \(xp\  = \ 
        40;\), "\[IndentingNewLine]", \(xf\ \  = \ 
        60;\), "\[IndentingNewLine]", \(yf\  = \ 
        60;\), "\[IndentingNewLine]", \(t[q_] := \ 
        Sqrt[xq^2 + q^2]/v1\ ;\), "\[IndentingNewLine]", \(tt[q_, p_] := \ 
        Sqrt[\((xp - xq)\)^2 + \((p - q)\)^2]/v2;\), "\[IndentingNewLine]", 
    RowBox[{\(ttt[p_]\  := \ Sqrt[\((xf - xp)\)^2\  + \ \((yf - p)\)^2]/v3;\),
       "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(T[q_, p_]\  := \ t[q]\  + \ tt[q, p]\  + \ ttt[p];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(M\  = \ Table[\ T[q, p], {p, 0, n}, {q, 0, n}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(v1\  = \ 
        14;\), "\[IndentingNewLine]", \(v2\  = \ 21;\), "\[IndentingNewLine]",
   
    RowBox[{\(v3\  = \ 52;\), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListPlot3D[M, 
        PlotLabel \[Rule] "\<M\>"];\), "\[IndentingNewLine]", \
\(ListContourPlot[M, \ Contours\  \[Rule] n, 
        PlotLabel \[Rule] "\<M\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowSize->{968, 570},
WindowMargins->{{-9, Automatic}, {Automatic, 49}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2052, 39, 728, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

