(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3144,         79]*)
(*NotebookOutlinePosition[      3790,        101]*)
(*  CellTagsIndexPosition[      3746,         97]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
G30MIRCV
Concave mirror
Radius of curvature is negative, xo is on left, is negative.
To get around the singularity at -xo = f one chooses the increments such that \
the
value for the singularity does not appear.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(r\  = \ \(-50\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(xo\  = \ \(-60\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(xi\  = \ \ 1/\((1/\((r/2)\) - 1/xo\ )\);\), 
      " ", \( (*\ xi\  = \ \(-42.857\)\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(m\  = \ \(-xi\)/xo;\), " ", \( (*\ m\  = \ \(-0.714\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(xxo\  = \ 
        Range[\(-100\), \(-0.1\), 0.9];\), "\[IndentingNewLine]", 
    RowBox[{\(xxi[xxo_]\  = \ 1/\((1/\((r/2)\)\  - \ 1/xxo)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{xxo, xxi[xxo]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<xxo\>", "\<xxi[xxo]\>"}, 
          PlotRange \[Rule] {{\(-100\), 0}, {\(-4000\), 2000}}], {{{Hue[
                1], "\<xxi[xxo]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{709, 589},
WindowMargins->{{-11, Automatic}, {Automatic, 13}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1435, 27, 476, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

