(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5307,        125]*)
(*NotebookOutlinePosition[      5952,        147]*)
(*  CellTagsIndexPosition[      5908,        143]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", 
        RowBox[{\(G32RESGG\[IndentingNewLine]
          Calculation\ of\ Resonator\ using\ g1\), ",", 
          RowBox[{
          "g2", " ", "and", " ", "d", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(", GridBox[{
                  {"1", "0"},
                  {\(\(g1 - d\)\/d\), "1"}
                  }], ")"}], 
            RowBox[{"(", GridBox[{
                  {"1", "d"},
                  {"0", "1"}
                  }], ")"}], 
            RowBox[{"(", GridBox[{
                  {"1", "0"},
                  {\(\(2*\((g2 - 1)\)\)\/d\), "1"}
                  }], ")"}], 
            RowBox[{"(", GridBox[{
                  {"1", "d"},
                  {"0", "1"}
                  }], ")"}], 
            RowBox[{"(", GridBox[{
                  {"1", "0"},
                  {\(\(g1 - 1\)\/d\), "1"}
                  }], ")"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(", GridBox[{
                  {\(\(-1\) + 2*g1*g2\), \(2*d*g2\)},
                  {\(2*g1*\((\(-1\) + g1*g2)\)\/d\), \(\(-1\) + 2*g1*g2\)}
                  }], ")"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]",
         "*)"}], "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        RowBox[{"vals", " ", "=", " ", 
          RowBox[{"Eigenvalues", "[", 
            RowBox[{"(", GridBox[{
                  {\(\(-1\) + 2*g1*g2\), \(2*d*g2\)},
                  {\(2*g1*\((\(-1\) + g1*g2)\)\/d\), \(\(-1\) + 2*g1*g2\)}
                  }], ")"}], "]"}]}], ";"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(r1\  = \ 
        1;\), "\[IndentingNewLine]", \(r2\  = \ 
        1;\), "\[IndentingNewLine]", \(d\  = \ 
        2;\), "\[IndentingNewLine]", \(g1\  = \ 
        1 - \ d/r1;\), "\[IndentingNewLine]", \(g2\  = \ 
        1 - d/r2;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]1\  = \ vals[\([1]\)]\ ;\), \( (*\ \[Lambda]1\  = \ 
          1\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]2\  = \ vals[\([2]\)];\), 
      " ", \( (*\ \[Lambda]2\  = \ 1\ *) \), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        We\ set\ the\ product\ g1g2 = 
          x\ and\ plot\ it\ over\ the\ range\ from - 1\ to\ 2\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(y[x_] = \ Abs[\((2*x - 1)\) + Sqrt[\((2*x - 1)\)^2 - 1]] - 1;\),
       "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(yy[x_] = \ 
        Abs[\((2*x - 1)\) - Sqrt[\((2*x - 1)\)^2 - 1]] - 
          1;\), "\[IndentingNewLine]", \(x = \ 
        Range[\(-1\), 2, 0.1];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, y[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<y[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 2}, {\(-5\), 5}}], {{{Hue[
                  1], "\<y[x]\>"}}, LegendPosition \[Rule] {1.1, \(-0\)}}];\),
       "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{x, yy[x]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<x\>", "\<yy[x]\>"}, 
          PlotRange \[Rule] {{\(-1\), 2}, {\(-5\), 5}}], {{{Hue[
                1], "\<yy[x]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{674, 599},
WindowMargins->{{11, Automatic}, {30, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3598, 73, 808, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

