(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3258,         86]*)
(*NotebookOutlinePosition[      3937,        109]*)
(*  CellTagsIndexPosition[      3893,        105]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{Cell[""], 
      RowBox[{"(*", " ", "\[IndentingNewLine]", 
        RowBox[{
          StyleBox[Cell["G4PRISM"],
            "Outline1"], 
          StyleBox["   ",
            "Outline1"], 
          StyleBox["\[IndentingNewLine]",
            "Outline1"], "\[IndentingNewLine]", Cell["\<\
Graph of the angle of deviation for refraction on a prism
depending on the angle of incidence

\[Theta]1 is the angle of incidence with respect to the normal
\[Delta]1  is the angle of deviation
n is the refractive index and A is the apex angle.\
\>"], Cell[TextData[StyleBox["",
            FontFamily->"Symbol",
            FontSize->10]]]}], "\[IndentingNewLine]", 
        "*)"}]}], "\[IndentingNewLine]", \(<< 
      Graphics`Legend`\), "\[IndentingNewLine]", \(n\  = \ 
        2;\), "\[IndentingNewLine]", \(A\  = \ \((\((2*Pi)\)/
              360)\)*30;\), "\[IndentingNewLine]", \(\[Theta]1\  = \ 
        Range[0, 1, 
          0.001];\), "\[IndentingNewLine]", \(\[Delta][\[Theta]1_] := \ \
\[Theta]1\  + \ 
          ArcSin[Sqrt[n^2 - \((Sin[\[Theta]1])\)^2]*Sin[A] - 
              Sin[\[Theta]1]*Cos[A]] - 
          A;\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta]1\ , \[Delta][\[Theta]1]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]1 \>", "\<\[Delta][\[Theta]1]\>"}], \
{{{Hue[1], "\<\[Delta][\[Theta]1]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowSize->{1016, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1549, 34, 398, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

