(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6181,        138]*)
(*NotebookOutlinePosition[      6825,        160]*)
(*  CellTagsIndexPosition[      6781,        156]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W13TRANCOHSIS
  
Coherent light.Fourier transformation of a periodic structure using FT of \
sinx/x as
transfer function\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(fn\  = \ 10;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]\  = \ 0.0005;\), 
      "\[IndentingNewLine]", \( (*\ 
        Object : 
          Sum\ of\ step\ functions\ *) \)}], "\[IndentingNewLine]", \(i\  = \ 
        Range[0, 255, 1];\), "\[IndentingNewLine]", \(b\  = \ 
        2;\), "\[IndentingNewLine]", 
    RowBox[{\(q\  = \ 14;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y\_i = \[Sum]\+\(n = \
0\)\%q\((UnitStep[i - \((4*\((2*n + 1)\) + 2)\)*b] - 
              UnitStep[
                i - \((4*\((2*n + 1)\) + 4)\)*b])\);\), "\[IndentingNewLine]",
   
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {0, 1.5}}], {{{Hue[
                  1], \*"\"\<\!\(y\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        FT\ of\ the\ object\ y\ is\ \[Omega]\ *) \)}], "\[IndentingNewLine]", \
\(\[Omega]\  = \ Fourier[y\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Omega]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 255}, {\(-2\), 4}}], {{{Hue[
                  1], "\<Re[\[Omega]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
The transfer function is FT of s (and not s squared)
FT of s is transfer function \[Tau]\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", \(ii = 
        Range[1, 255, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(s\_ii = 
          4*\((Sin[\(Pi*ii\)\/\(fn*\[Lambda]*255\)]\/\(\(Pi*ii\)\/\(fn*\
\[Lambda]*255\)\))\);\), 
      "\[IndentingNewLine]", \( (*\ error\ correction, \ 
        division\ by\ zero\ at\ the\ first\ element\ *) \)}], "\
\[IndentingNewLine]", \(s\_i = PadLeft[s\_ii, 256];\), "\[IndentingNewLine]", 
  
    RowBox[{\(\[Tau]\  = \ Fourier[s\_i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Tau]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.2\), 0.1}}], {{{Hue[
                  1], "\<Re[\[Tau]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Product\ of\ FT\ of\ object\ and\ transfer\ function\ is\ the\ \
modified\ \(FT : \[Phi]\)\ *) \)}], "\[IndentingNewLine]", \(\[Phi]\  = \ \
\[Tau]*\[Omega];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[\[Phi]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-0.2\), 0.5}}], {{{Hue[
                  1], "\<Re[\[Phi]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        FT\ \((inverse)\)\ of\ the\ modified\ FT\ is\ the\ amplitude\ of\ the\
\ image\ yy\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(yy\  = \ InverseFourier[\[Phi]];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ image\ is\ the\ absolute\ value\ of\ yy\ squared\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{i, yy\^2}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 300}, {0, 0.005}}], {{{Hue[
                1], \*"\"\<\!\(yy\^2\)\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{484, 599},
WindowMargins->{{25, Automatic}, {Automatic, 9}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4472, 86, 1488, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

