(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7317,        156]*)
(*NotebookOutlinePosition[      7962,        178]*)
(*  CellTagsIndexPosition[      7918,        174]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
W18HOSTEPS
  
The object y has a complicated shape.Its FT is the hologram c.It may be \
produced in the focal plane of a lens,using parallel light.
    
The illumination of the hologram with parallel light will reproduce the \
object,that is the FT(inverse) of the FT,called here cc.
    
We want to study the reproduced object when the information in the hologram \
is only partly used,that is we multiply cc with a filter f.We show separately \
f and the FT of the product of f and cc.
    
The width of the filter f may be changed by using various values for \"a\" \
and \"b\",corresponding to changing the size of the hologram.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(i\  = \ 
        Range[0, 255, 1];\), "\[IndentingNewLine]", \(A\_1 = 
        33;\), "\[IndentingNewLine]", \(A\_2 = 
        80;\), "\[IndentingNewLine]", \(A\_3 = 
        80;\), "\[IndentingNewLine]", \(A\_4 = 
        50;\), "\[IndentingNewLine]", \(A\_5 = 
        20;\), "\[IndentingNewLine]", \(A\_6 = 
        99;\), "\[IndentingNewLine]", \(A\_7 = 
        160;\), "\[IndentingNewLine]", \(A\_8 = 
        200;\), "\[IndentingNewLine]", \(y\_i = \[Sum]\+\(n = \
1\)\%3\((\(-UnitStep[A\_n - i]\))\) + \[Sum]\+\(n = 4\)\%8\((UnitStep[
                  A\_n - i]*\((\(-1\))\)\^n)\);\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-2\), 2}}], {{{Hue[
                  1], \*"\"\<\!\(y\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ hologram\ *) \)}], "\[IndentingNewLine]", \(c = \ 
        Fourier[y\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[c]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-5\), 5}}], {{{Hue[
                  1], "\<Re[c]\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
The FT of the hologram
The FT of the FT(hologram)\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", \(cc = 
        c;\), "\[IndentingNewLine]", \(yy = \ 
        InverseFourier[cc];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[yy]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 255}, {\(-4\), 2}}], {{{Hue[
                  1], "\<Re[yy]\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ filter\ *) \)}], "\[IndentingNewLine]", \(a\  = \ 
        60;\), "\[IndentingNewLine]", \(b\  = \ 60;\), "\[IndentingNewLine]", 
  
    RowBox[{\(f\_i = UnitStep[a - i] + UnitStep[i - 255 + b];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, f\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {0, 2}}], {{{Hue[
                  1], \*"\"\<\!\(f\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ \(product : 
            hologram\ x\ filter\)\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[c]*f\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-5\), 5}}], {{{Hue[
                  1], \*"\"\<Re[c]*\!\(f\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\[IndentingNewLine]The\ FT\ \((inverse)\)\ \
of\ the\ changed\ hologram\ \((hologram\ x\ filter)\), 
        similar\ to\ the\ object\[IndentingNewLine]*) \)}], "\
\[IndentingNewLine]", \(ccc\  = \ c*f\_i;\), "\[IndentingNewLine]", \(x\  = \ 
        InverseFourier[ccc];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, Re[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 300}, {\(-4\), 2}}], {{{Hue[
                  1], "\<Re[x]\>"}}, LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        For\ \(comparison : \ 
            The\ object\)\ *) \)}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{i, y\_i}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 300}, {\(-2\), 2}}], {{{Hue[
                1], \*"\"\<\!\(y\_i\)\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{490, 599},
WindowMargins->{{6, Automatic}, {Automatic, -11}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5608, 104, 1995, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

