(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4890,        110]*)
(*NotebookOutlinePosition[      5535,        132]*)
(*  CellTagsIndexPosition[      5491,        128]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\[IndentingNewLine]A4SPHLSIPIS\[IndentingNewLine]Spherical\ \
Aberration\ and\ the\ pi - sigma\ equation\[IndentingNewLine]We\ assume\ n = 
        1.5\ and\ compare\ the\ cases\ of\ real\ and\ virtual\ \
\(\(images\)\(.\)\)\[IndentingNewLine]\[IndentingNewLine]*) \
\[IndentingNewLine]<< "\<Graphics`Legend`\>"\[IndentingNewLine] (*1. \ Image\ \
for\ f = 10, and\ xo\ to\ the\ left\ of\ focal\ point, 
      LSA\ may\ not\ be\ eliminated\ *) \), "\[IndentingNewLine]", 
    \(\(r1\  = \ 10;\)\), "\[IndentingNewLine]", 
    \(\(r2\  = \ \(-10\);\)\), "\[IndentingNewLine]", 
    \(\(n\  = \ 1.5;\)\), "\[IndentingNewLine]", 
    \(\(ro\  = \ 4;\)\), "\[IndentingNewLine]", 
    \(\(xo\  = \ 4;\)\), "\[IndentingNewLine]", 
    \(\(f\  = \ 1\/\(\((n - 1)\)*\((1\/r1 - 1\/r2)\)\)\ ;\) (*\ 
      f = 10\ *) \), "\[IndentingNewLine]", 
    \(\(xi\  = \ 1\/\((1\/f + 1\/xo)\)\ ;\) (*\ 
      xi\  = \ 2.857\ *) \[IndentingNewLine] (*\ 
      2. \ Definitions\ *) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      Definition : \ \[Sigma]\  = \ \((r2 - r1)\)/\((r2 + 
              r1)\)\ *) \), "\[IndentingNewLine]", 
    \(\(\[Sigma] = Range[\(-10\), 10, 0.1];\)\), "\[IndentingNewLine]", 
    \(\(\[Pi]\[Pi] = \(xi + xo\)\/\((xi - xo)\);\)\  (*\ \[Pi]\[Pi] = \(-6\)\ \
*) \[IndentingNewLine]\[IndentingNewLine] (*\ 
      3. \ \[Pi] - \[Sigma]\ Equation\ *) \[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(A[
          n_] := \ \(n + 2\)\/\(8*n*\((n - 1)\)\^2\);\)\), "\
\[IndentingNewLine]", 
    \(\(B[
          n_] := \ \(n + 1\)\/\(2*n*\((n - 1)\)\);\)\), \
"\[IndentingNewLine]", 
    \(\(CC[n_] := \ \(3*n + 2\)\/\(8*n\);\)\), "\[IndentingNewLine]", 
    \(\(DD[n_] := \ n\^2\/\(8*\((n - 1)\)\^2\);\)\), "\[IndentingNewLine]", 
    \(\(Y[\[Sigma]_] := \ \((ro)\)\^2\/f\^3*\((A[n]*\[Sigma]\^2 + 
              B[n]*\[Sigma]*\[Pi]\[Pi] + CC[n]*\[Pi]\[Pi]\^2 + 
              DD[n])\);\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(ShowLegend[
        ListPlot[Transpose[{\[Sigma], Y[\[Sigma]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Sigma]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-10\), 10}, {0, 0.1}}], {{{Hue[
                1], "\<Y[\[Sigma]]\>"}}, 
          LegendPosition \[Rule] {1.1, 
              0}}];\)\[IndentingNewLine]\[IndentingNewLine] (*\ 
      4. \ Minimum\ value\ of\ Y \((s)\)\ *) \[IndentingNewLine] (*\ 
      The\ value\ of\ Y \((s)\)\ at\ the\ minimum\ is\ obtained\ by\ \
differentiation\ and\ equating\ equal\ to\ 0. \ The\ result\ is\ *) \), "\
\[IndentingNewLine]", 
    \(\(\[Sigma]min = \ \(-B[
              n]\)*\[Pi]\[Pi]\/\(2*A[n]\);\)\  (*\ \[Sigma]min = \ 
        4.286\ *) \n (*\ 
      Calculation\ of\ the\ corresponding\ value\ of\ Y \((\[Sigma]\ min)\)\ *) \
\), "\[IndentingNewLine]", 
    \(\(Y[\[Sigma]min];\)\  (*\ 
      Y[\[Sigma]min]\  = \ \(-0.013\)\ *) \[IndentingNewLine]\
\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \( (*\ for\ our\ choice\ of\ parameters, 
      Y \((\[Sigma]\ min)\)\ is\ positive\ and\ LSA\ may\ not\ be\ \
\(\(eliminated\)\(.\)\)\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{-2, Automatic}, {31, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3181, 58, 1153, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

