(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4342,        103]*)
(*NotebookOutlinePosition[      4987,        125]*)
(*  CellTagsIndexPosition[      4943,        121]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
A5COMAS
The tangential coma CT and sagittal coma CS are calulated depending on r \
using third order theory expressions.For similar expressions see Jenkins and \
White,4th Ed,p.163.
    
1. No coma and spherical aberration\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(r1\  = \ 
        11;\), "\[IndentingNewLine]", \(r2\  = \ \(-10\);\), "\
\[IndentingNewLine]", \(xo\  = \ \(-30\);\), "\[IndentingNewLine]", \(n\  = \ 
        1.3168;\), "\[IndentingNewLine]", \(f\  = \ 
        1\/\(\((1\/r1 - 1\/r2)\)*\((n - 1)\)\);\), "\[IndentingNewLine]", 
    RowBox[{\(xi\  = 1\/\((1\/f + 1\/xo)\);\), 
      " ", \( (*\ xi = \ 36.837\ *) \), 
      "\[IndentingNewLine]", \( (*\ 
        2. \ Definitions\ for\ calculations\ of\ coma\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(\[Pi]\[Pi]\  = \ \(xi + xo\)\/\((xi - xo)\);\), 
      " ", \( (*\ \[Pi]\[Pi]\  = \ 0.102\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\[Sigma] = \ \(r2 + r1\)\/\(r2 - r1\);\), 
      "  ", \( (*\ \[Sigma]\  = \ \(-0.048\)\ *) \)}], "\[IndentingNewLine]", \
\(\[Rho]\  = \ 1.5;\), "\[IndentingNewLine]", 
    RowBox[{\(G = \ \(3*\((2*n + 1)\)\)\/\(4*n\);\), 
      " ", \( (*\ G\  = \ 2.07\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(W\  = \ \(3*\((n + 1)\)\)\/\(4*n*\((n - 1)\)\);\), 
      " ", \( (*\ W\  = \ 4.165\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ZZ\  = \ W*\[Sigma] + G*\[Pi]\[Pi];\), 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Tangential\ Coma\ CT\ as\ function\ of\ \[Rho]\ *) \)}], "\
\[IndentingNewLine]", \(\[Rho]\  = \ 
        Range[0, 1, 0.01];\), "\[IndentingNewLine]", \(\[Beta]\  = \ 
        0.05;\), "\[IndentingNewLine]", 
    RowBox[{\(CT[\[Rho]_] := \ \[Rho]\^2*\(ZZ*Tan[\[Beta]]\)\/f\^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Rho], CT[\[Rho]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Rho]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1}, {0, 3*10\^\(-6\)}}], {{{Hue[
                  1], "\<CT[\[Rho]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "\[IndentingNewLine]", Cell["\<\
4. Condition for elimination of coma
 If \[Sigma]=-((2n+1)(n-1)/(n+1))\[Pi]
 CT is zero for all zones
 CS=1/3 CT\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 612},
WindowMargins->{{14, Automatic}, {20, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2633, 51, 967, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

