(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4746,        108]*)
(*NotebookOutlinePosition[      5391,        130]*)
(*  CellTagsIndexPosition[      5347,        126]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", Cell["\<\
I10WEDGES
  
Fringes of a wedge given by y.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(\[Alpha]\  = \ 
        0.002;\), "\[IndentingNewLine]", \(\[Lambda]1\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(\[Lambda]2\  = \ 
        0.0008;\), "\[IndentingNewLine]", \(\[Lambda]3\  = \ 
        0.0012;\), "\[IndentingNewLine]", \(x\  = \ 
        Range[0, 1, 0.01];\), "\[IndentingNewLine]", \(y1[
          x_, \[Lambda]1_] := \ 
        Cos[2*Pi*x*Tan[\[Alpha]]/\[Lambda]1 + 
              Pi/2]^2;\), "\[IndentingNewLine]", \(y2[x_, \[Lambda]2_] := \ 
        Cos[2*Pi*x*Tan[\[Alpha]]/\[Lambda]2 + 
              Pi/2]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(y3[x_, \[Lambda]3_] := \ 
          Cos[2*Pi*x*Tan[\[Alpha]]/\[Lambda]3 + Pi/2]^2;\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{x, y1[x, \[Lambda]1]}], 
            Transpose[{x, y2[x, \[Lambda]2]}], 
            Transpose[{x, y3[x, \[Lambda]3]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
            PlotRange \[Rule] {{0, 1}, {0, 1}}], {{{Hue[
                  1], "\<y1[x,\[Lambda]1]\>"}, {Hue[
                  0.5], "\<y2[x,\[Lambda]2]\>"}, {Hue[
                  0.25], "\<y3[x,\[Lambda]3]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]", \( (*\ 
        Height\ at\ x\ *) \)}], "\[IndentingNewLine]", \(h[x_]\  := 
        x*Tan[\[Alpha]];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, h[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<h[x]\>"}, 
            PlotRange \[Rule] {{0, 1}, {0, 0.003}}], {{{Hue[1], "\<h[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Distance\ between\ two\ Maxima\ depending\ on\ \[Alpha]\ xx = \ \
\[Lambda]/\((2\ tan\ \[Alpha])\)\ *) \)}], "\[IndentingNewLine]", \(\[Lambda]\
\  = \ Range[0.0001, 0.0015, 
          0.0001];\), "\[IndentingNewLine]", \(xx[\[Lambda]_]\  := \ \
\[Lambda]/\((2*Tan[\[Alpha]])\);\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Lambda], xx[\[Lambda]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Lambda]\>", "\<xx[\[Lambda]]\>"}, 
          PlotRange \[Rule] {{0, 0.0015}, {0, 0.4}}], {{{Hue[
                1], "\<xx[\[Lambda]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{770, 599},
WindowMargins->{{21, Automatic}, {Automatic, 10}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3037, 56, 726, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

