(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3300,         83]*)
(*NotebookOutlinePosition[      3945,        105]*)
(*  CellTagsIndexPosition[      3901,        101]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I13MICHANS
Michelson interferometer, Dependence on \[Theta].
    
Fringe pattern depending on angle \[Theta] for two fixed wavelength \[Lambda] \
and \[Lambda]\[Lambda], and fixed displacement D. An ideal beamsplitter is \
assumed.
All length in mm.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(\[Lambda] = \ 
        0.0005;\), "\[IndentingNewLine]", \(DD\  = \ 
        0.05;\), "\[IndentingNewLine]", \(\[Lambda]\[Lambda] = \ 
        0.00052;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-0.301\), \ 0.3, 
          0.001];\), "\[IndentingNewLine]", \(IM1[\[Theta]_]\  := \ 
        Cos[\((2*Pi*DD*
                  Cos[\[Theta]])\)/\[Lambda]]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(IM2[\[Theta]_]\  := \ 
          Cos[\((2*Pi*DD*Cos[\[Theta]])\)/\[Lambda]\[Lambda]]^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], IM1[\[Theta]]}], 
          Transpose[{\[Theta], IM2[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<I\>"}, 
          PlotRange \[Rule] {{\(-0.4\), 0.3}, {0, 1}}], {{{Hue[
                1], "\<IM1[\[Theta]]\>"}, {Hue[0.5], "\<IM2[\[Theta]]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{-9, Automatic}, {Automatic, -1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1591, 31, 546, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

