(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4336,        101]*)
(*NotebookOutlinePosition[      4979,        123]*)
(*  CellTagsIndexPosition[      4935,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", " ", Cell["\<\
I14PLANIDS
Normal incidence. Plane parallel plate, reflected and transmitted intensity \
depending on thickness for fixed wavelength.
      
The reflection coefficients are calculated from Fresnels formulas for \
\[Theta] = 0. Refractive indices n1, n2 and n3 may all be different and the \
reflection coefficient for both surfaces are calculated.
    
The calculation of the fringe pattern is done depending on D for fixed \
\[Lambda].
\[CapitalDelta] = 2\[Pi]/\[Lambda] 2dn2\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 1.5;\), "\[IndentingNewLine]",
   
    RowBox[{\(n3\  = \ 1;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(r12\  = \ \((n2 - n1)\)/\((n2 + n1)\);\), \( (*\ 
        r12\  = \ 0.2\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(r23\  = \ \((n3 - n2)\)/\((n3 + n2)\);\), \( (*\ 
        r23\  = \ \(-0.2\)\ *) \), 
      "\[IndentingNewLine]", \( (*\ \[CapitalDelta] = 
          2  \[Pi]/\[Lambda]\ 2  dn2\ cos\ \[Theta]2\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(DD\  = \ 
        Range[0.0002, 0.002, 0.00001];\), "\[IndentingNewLine]", \(IT[
          DD_] = \ \((\((1 - r12^2)\)*\((1 - 
                  r23^2)\))\)/\((1 + \((r12*r23)\)^2 - \((2*r12*r23)\)*
                Cos[4*Pi*\((DD/\[Lambda])\)*n2])\);\), "\[IndentingNewLine]", 
  
    RowBox[{\(IR[DD_]\  = \ 1 - IT[DD];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Transmitted\ pattern\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{DD, N[IT[DD]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<DD\>", "\<IT[DD]\>"}, 
            PlotRange \[Rule] {{0, 0.002}, {0, 1}}], {{{Hue[
                  1], "\<IT[DD]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Reflected\ pattern\ *) \)}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{DD, N[IR[DD]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<DD\>", "\<IR[DD]\>"}, 
          PlotRange \[Rule] {{0, 0.002}, {0, 1}}], {{{Hue[1], "\<IR[DD]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{5, Automatic}, {Automatic, 8}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2627, 49, 956, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

