(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5703,        128]*)
(*NotebookOutlinePosition[      6346,        150]*)
(*  CellTagsIndexPosition[      6302,        146]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I1COSWS

Cosine function depending on x,t,and a phase constant.Interchanging x/\
\[Lambda] with t/T in the phase factor 2\[Pi](x/\[Lambda]-t/T) has no effect \
on the cosine function.We see an equivalent dependence of the cos-function on \
x/\[Lambda] and t/T.Two sets of each three functions are shown,they give the \
same graphs when
changing the dependence on x or t,using the same range,and leaving
the other corresponding parameters the same.In the way the cosine functions \
are written,an additional phase factor may
have its origin in the space or time part,we do not know.\
\>"], "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`MultipleListPlot`\)}], "\[IndentingNewLine]", 
    RowBox[{\(<< Graphics`Legend`\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(x1\  = \ 
        Range[0, 10, 0.1];\), "\[IndentingNewLine]", \(\[Lambda] = \ 
        1;\), "\[IndentingNewLine]", 
    RowBox[{\(T\  = \ 10;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(A1\  = \ 1; \ A2\  = \ 1; \ A3\  = \ 1;\), 
      " "}], "\[IndentingNewLine]", \(t1\  = \ 1; \ t2\  = \ 2; \ 
    t3\  = \ 3;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Phi]1\  = \ 0.5; \ \[Phi]2\  = \ 0.2; \ \ \[Phi]3\  = \ 
        0.1;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ua1[
          x1_]\  = \ 
        A1*Cos[2*
              Pi*\((x1/\[Lambda] - 
                  t1/T + \[Phi]1)\)];\), "\[IndentingNewLine]", \(ua2[
          x1_]\  = \ 
        A2*Cos[2*
              Pi*\((x1/\[Lambda] - 
                  t2/T + \[Phi]2)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(ua3[x1_]\  = \ 
          A3*Cos[2*Pi*\((x1/\[Lambda] - t3/T + \[Phi]3)\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{x1, ua1[x1]}], 
            Transpose[{x1, ua2[x1]}], Transpose[{x1, ua3[x1]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<x1\>", "\<ua\>"}, 
            PlotRange \[Rule] {{0, 10}, {\(-1\), 1}}], {{{Hue[
                  1], "\<ua1[x1]\>"}, {Hue[0.5], "\<ua2[x1]\>"}, {Hue[
                  0.25], "\<ua3[x1]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(t1\  = \ 
        Range[0, 10, 
          0.1];\), "\[IndentingNewLine]", \(\[Lambda]\[Lambda]\  = \ 
        10;\), "\[IndentingNewLine]", \(TT\  = \ 
        1;\), "\[IndentingNewLine]", \(B1\  = \ 1; \ B2\  = \ 1; \ 
    B3\  = \ 1;\), "\[IndentingNewLine]", \(x1\  = \ 1; \ x2\  = \ 2; \ 
    x3\  = \ 3;\), "\[IndentingNewLine]", 
    RowBox[{\(\[CurlyPhi]1\  = \ 1; \ \ \[CurlyPhi]2\  = \ 
        1; \ \[CurlyPhi]3\  = \ 1;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ub1[t1_]\  = \ 
        B1*Cos[2*
              Pi*\((x1/\[Lambda]\[Lambda] - 
                  t1/TT + \[CurlyPhi]1)\)];\), "\[IndentingNewLine]", \(ub2[
          t1_]\  = \ 
        B2*Cos[2*
              Pi*\((x2/\[Lambda]\[Lambda] - 
                  t1/TT + \[CurlyPhi]2)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(ub3[t1_]\  = \ 
          B3*Cos[2*Pi*\((x3/\[Lambda]\[Lambda] - t1/TT + \[CurlyPhi]3)\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{t1, ub1[t1]}], Transpose[{t1, ub2[t1]}], 
          Transpose[{t1, ub3[t1]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<t1\>", "\<ub\>"}, 
          PlotRange \[Rule] {{0, 10}, {\(-1\), 1}}], {{{Hue[
                1], "\<ub1[t1]\>"}, {Hue[0.5], "\<ub2[t1]\>"}, {Hue[
                0.25], "\<ub3[t1]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{961, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3994, 76, 970, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

