(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3049,         79]*)
(*NotebookOutlinePosition[      3696,        101]*)
(*  CellTagsIndexPosition[      3652,         97]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I21RANDS
Addition of exponential-functions with random angles

The real part of the sum of exp i \[Theta] is plotted\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(f\  = \ 
        Range[1, 100, 1];\), "\[IndentingNewLine]", \(k\  = \ 
        Range[1, 100, 1];\), "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", \(n\_f = \ 
        f;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\_k = \ 
          Table[\ Random[Real, {0, 2\ *\ Pi}, 10]\ \ , \ {k, 1, 100}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(\(\(y\)\(\ \)\)\_f = 
          1\/n\_f*Sum[
              Evaluate[\((\[ExponentialE]^\((i*\[Theta]\_k)\))\)], {k, 0, 
                n\_f, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{f, Re[y\_f]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<f\>", \*"\"\<Re[\!\(y\_f\)]\>\""}, 
          PlotRange \[Rule] {{0, 100}, {\(-1\), 2}}], {{{Hue[
                1], \*"\"\<Re[\!\(y\_f\)]\>\""}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{120, Automatic}, {Automatic, -13}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1340, 27, 446, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

