(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4426,        101]*)
(*NotebookOutlinePosition[      5070,        123]*)
(*  CellTagsIndexPosition[      5026,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I2COSSUPS
Superposition of two cosine waves,one having an optical path differnce \
\[Delta] with respect to the other. The sum is squared to result in the \
intensity.
We are looking at a time instance and graphs are shown for six different path \
differences.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`MultipleListPlot`\>"\)}], "\n", \
\(<< "\<Graphics`Legend`\>"\), "\n", \(x = 
        Range[0, 4, 0.05];\), "\n", \(\[Lambda] = 1;\), "\n", \(A = 
        1;\), "\n", \(T = 1;\), "\n", \(t1 = 0.1;\), "\n", \(\[Delta]1 = 
        0;\), "\n", \(\[Delta]2 = 0.1;\), "\n", \(\[Delta]3 = 
        0.2;\), "\n", \(\[Delta]4 = 0.3;\), "\n", \(\[Delta]5 = 
      0.4; \[Delta]6 = 
      0.5;\), "\n", \(u1[x_] := 
        A\ Cos[2\ \[Pi]\ \((x\/\[Lambda] - t1\/T)\)] + 
          A\ Cos[2\ \[Pi]\ \((\(x - \[Delta]1\)\/\[Lambda] - 
                    t1\/T)\)];\), "\n", \(u2[x_] := 
        A\ Cos[2\ \[Pi]\ \((x\/\[Lambda] - t1\/T)\)] + 
          A\ Cos[2\ \[Pi]\ \((\(x - \[Delta]2\)\/\[Lambda] - 
                    t1\/T)\)];\), "\n", \(u3[x_] := 
        A\ Cos[2\ \[Pi]\ \((x\/\[Lambda] - t1\/T)\)] + 
          A\ Cos[2\ \[Pi]\ \((\(x - \[Delta]3\)\/\[Lambda] - 
                    t1\/T)\)];\), "\n", \(u4[x_] := 
        A\ Cos[2\ \[Pi]\ \((x\/\[Lambda] - t1\/T)\)] + 
          A\ Cos[2\ \[Pi]\ \((\(x - \[Delta]4\)\/\[Lambda] - 
                    t1\/T)\)];\), "\n", \(u5[x_] := 
        A\ Cos[2\ \[Pi]\ \((x\/\[Lambda] - t1\/T)\)] + 
          A\ Cos[2\ \[Pi]\ \((\(x - \[Delta]5\)\/\[Lambda] - 
                    t1\/T)\)];\), "\n", \(u6[x_] := 
        A\ Cos[2\ \[Pi]\ \((x\/\[Lambda] - t1\/T)\)] + 
          A\ Cos[2\ \[Pi]\ \((\(x - \[Delta]6\)\/\[Lambda] - 
                    t1\/T)\)];\), "\n", \(ShowLegend[
        MultipleListPlot[Transpose[{x, u1[x]\^2}], Transpose[{x, u2[x]\^2}], 
          Transpose[{x, u3[x]\^2}], Transpose[{x, u4[x]\^2}], 
          Transpose[{x, u5[x]\^2}], Transpose[{x, u6[x]\^2}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1], 
              Hue[0.45], Hue[0.8]}, AxesLabel \[Rule] {"\<x\>", "\<u\>"}, 
          PlotRange \[Rule] {{0, 4}, {0, 4}}], {{{Hue[
                1], "\<u1(x\!\(\()\^2\)\)\>"}, {Hue[
                0.5], "\<u2(x\!\(\()\^2\)\)\>"}, {Hue[
                0.25], "\<u3(x\!\(\()\^2\)\)\>"}, {Hue[
                0.1], "\<u4(x\!\(\()\^2\)\)\>"}, {Hue[
                0.45], "\<u5(x\!\(\()\^2\)\)\>"}, {Hue[
                0.8], "\<u6(x\!\(\()\^2\)\)\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{909, 625},
WindowMargins->{{34, Automatic}, {Automatic, 3}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2717, 49, 738, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

