(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7277,        157]*)
(*NotebookOutlinePosition[      7921,        179]*)
(*  CellTagsIndexPosition[      7877,        175]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I4COSINTS
  
Intensity in real and complex notation
Real notation for maxima\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(x\  = \ Range[0, 4, 0.01];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        1;\), "\[IndentingNewLine]", \(A\  = \ 
        1;\), "\[IndentingNewLine]", \(t\  = \ 
        1;\), "\[IndentingNewLine]", \(T\  = \ 10;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Delta]\  = \ 0;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(u[x_]\  := \ 
          A*Cos[2*Pi*\((x/\[Lambda] - t/T)\)]\  + \ 
            A*Cos[2*Pi*\((\((x - \[Delta])\)/\[Lambda] - t/T)\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, u[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<u[x]\>"}, 
            PlotRange \[Rule] {{0, 4}, {\(-2\), 2}}], {{{Hue[
                  1], "\<u[x]\>"}}, LegendPosition \[Rule] {1.1, \(-0\)}}];\),
       "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, u[x]\^2}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", \*"\"\<u[x\!\(\(]\^2\)\)\>\""}, 
            PlotRange \[Rule] {{0, 4}, {0, 4}}], {{{Hue[
                  1], \*"\"\<u[x\!\(\(]\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ time\ average\ of\ the\ intensity\ is\ 1/
            2\ of\ the\ maximum\ value\ 4\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(t\  = \ 1;\), 
      "\[IndentingNewLine]", \( (*\ 
        Complex\ notation\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Sqrt[\(-1\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(z[x_]\  = \ 
          Exp[i*2*Pi*\((x/\[Lambda] - t/T)\)] + 
            A*Exp[i*2*Pi*\((\((x - \[Delta])\)/\[Lambda] - t/T)\)];\), 
      "\[IndentingNewLine]", \( (*\ 
        The\ real\ part\ of\ z \((x)\)\ is\ Re \((z \((x)\))\)\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, Re[z[x]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<Re[z[x]]\>"}, 
            PlotRange \[Rule] {{0, 4}, {\(-2\), 2}}], {{{Hue[
                  1], "\<Re[z[x]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        The\ real\ part\ squared\ is\ [Re \((z \((x)\))\)]^2\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, Re[z[x]]\^2}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", \*"\"\<Re[z[x]\!\(\(]\^2\)\)\>\""}, 
            PlotRange \[Rule] {{0, 4}, {0, 4}}], {{{Hue[
                  1], \*"\"\<Re[z[x]\!\(\(]\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      
      RowBox[{"(*", "\[IndentingNewLine]", " ", Cell["\<\
When taking z time z*,the time dependence is automatically eliminated and we \
get
twice of the average value.\
\>"], "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, z[x]*Conjugate[z[x]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<z[x]*Conjugate[z[x]]\>"}, 
            PlotRange \[Rule] {{0, 4}, {3.995, 4.005}}], {{{Hue[
                  1], "\<z[x]*Conjugate[z[x]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Complex\ notation\ and\ dependance\ on\ the\ optical\ path\ differnce\
\ \[Delta]\[Delta]\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Delta]\[Delta]\  = \
\ Range[0, 5, 0.01];\), "\[IndentingNewLine]", 
    RowBox[{\(x\  = \ 1;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(zz[\[Delta]\[Delta]_]\
\  = \ Exp[i*2*Pi*\((x/\[Lambda] - t/T)\)] + 
          A*Exp[i*2*
                Pi*\((\((x - \[Delta]\[Delta])\)/\[Lambda] - 
                    t/T)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[
            Transpose[{\[Delta]\[Delta], 
                zz[\[Delta]\[Delta]]*Conjugate[zz[\[Delta]\[Delta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Delta]\[Delta]\>", \
"\<zz[\[Delta]\[Delta]]*Conjugate[zz[\[Delta]\[Delta]]]\>"}, 
            PlotRange \[Rule] {{0, 6}, {0, 4}}], {{{Hue[
                  1], "\<zz[\[Delta]\[Delta]]*Conjugate[zz[\[Delta]\[Delta]]]\
\>"}}, LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \( (*\ 
      We\ see\ the\ "\<fringe pattern\>"\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{893, 599},
WindowMargins->{{17, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5568, 105, 1345, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

