(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3753,         94]*)
(*NotebookOutlinePosition[      4396,        116]*)
(*  CellTagsIndexPosition[      4352,        112]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I9PLANS

Fringes of plane parallel plate produced by two waves

1. For normal incidence depending on D
\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", 
    RowBox[{\(n2\  = \ 1.5;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(DD\  = \ 
        Range[\(-0.00051\), 0.005, 0.00001];\), "\[IndentingNewLine]", 
    RowBox[{\(I1[DD_]\  = \ Cos[\((2*Pi*DD*n2)\)/\[Lambda] + Pi/2]^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{DD, I1[DD]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<DD\>", "\<I1[DD]\>"}, 
            PlotRange \[Rule] {{\(-0.001\), 0.005}, {0, 1}}], {{{Hue[
                  1], "\<I1[DD]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        For\ normal\ incidence\ depending\ on\ \[Lambda]\ *) \)}], "\
\[IndentingNewLine]", \(\[Lambda]\[Lambda]\  = \ 
        Range[0.05, 0.5, 0.001];\), "\[IndentingNewLine]", \(DDD\  = \ 
        0.05;\), "\[IndentingNewLine]", 
    RowBox[{\(I2[\[Lambda]\[Lambda]_]\  = \ 
          Cos[\((2*Pi*DDD*n2)\)/\[Lambda]\[Lambda] + Pi/2]^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Lambda]\[Lambda], I2[\[Lambda]\[Lambda]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Lambda]\[Lambda]\>", "\<I2[\[Lambda]\
\[Lambda]]\>"}, 
          PlotRange \[Rule] {{0, 0.5}, {0, 1}}], {{{Hue[
                1], "\<I2[\[Lambda]\[Lambda]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{527, 599},
WindowMargins->{{2, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2044, 42, 680, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

